/*
 * Decompiled with CFR 0.152.
 */
package io.ably.lib.http;

import io.ably.lib.http.Http;
import io.ably.lib.types.AblyException;
import io.ably.lib.types.Callback;
import io.ably.lib.types.ErrorInfo;
import io.ably.lib.types.Param;
import io.ably.lib.util.Log;
import java.net.URL;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AsyncHttp
extends ThreadPoolExecutor {
    private final Http http;
    private static final int DEFAULT_POOL_SIZE = 0;
    private static final int MAX_POOL_SIZE = 64;
    private static final long KEEP_ALIVE_TIME = 2000L;
    private static final long SHUTDOWN_TIME = 5000L;
    private static final String TAG = AsyncHttp.class.getName();

    public <T> void get(String path, Param[] headers, Param[] params, Http.ResponseHandler<T> responseHandler, Callback<T> callback) {
        this.ablyHttpExecute(path, "GET", headers, params, null, responseHandler, callback);
    }

    public <T> void post(String path, Param[] headers, Param[] params, Http.RequestBody requestBody, Http.ResponseHandler<T> responseHandler, Callback<T> callback) {
        this.ablyHttpExecute(path, "POST", headers, params, requestBody, responseHandler, callback);
    }

    public <T> void del(String path, Param[] headers, Param[] params, Http.ResponseHandler<T> responseHandler, Callback<T> callback) {
        this.ablyHttpExecute(path, "DELETE", headers, params, null, responseHandler, callback);
    }

    public AsyncHttp(Http http) {
        super(0, 64, 2000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.http = http;
    }

    public void setThreadPoolSize(int size) {
        this.setCorePoolSize(size);
    }

    public <T> void httpExecute(final URL url, final String method, final Param[] headers, final Http.RequestBody requestBody, final boolean withCredentials, final Http.ResponseHandler<T> responseHandler, final Callback<T> callback) {
        this.submit(new Runnable(){

            @Override
            public void run() {
                Object result = null;
                try {
                    result = AsyncHttp.this.http.httpExecute(url, method, headers, requestBody, withCredentials, responseHandler);
                }
                catch (AblyException e) {
                    callback.onError(e.errorInfo);
                    return;
                }
                callback.onSuccess(result);
            }
        });
    }

    public <T> void ablyHttpExecute(final String path, final String method, final Param[] headers, final Param[] params, final Http.RequestBody requestBody, final Http.ResponseHandler<T> responseHandler, final Callback<T> callback) {
        this.submit(new Runnable(){

            @Override
            public void run() {
                Object result = null;
                ErrorInfo error = null;
                try {
                    result = AsyncHttp.this.http.ablyHttpExecute(path, method, headers, params, requestBody, responseHandler);
                }
                catch (AblyException e) {
                    error = e.errorInfo;
                }
                try {
                    if (error != null) {
                        callback.onError(error);
                    } else {
                        callback.onSuccess(result);
                    }
                }
                catch (Throwable t) {
                    Log.e(TAG, "Exception invoking callback", t);
                }
            }
        });
    }

    public void dispose() {
        this.shutdown();
        try {
            this.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.shutdownNow();
        }
    }
}

