package io.ably.lib.types;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;

import io.ably.lib.util.Serialisation;

public class ProtocolSerializer {

	/****************************************
	 *            Msgpack decode
	 ****************************************/
	
	public static ProtocolMessage readMsgpack(byte[] packed) throws AblyException {
		try {
			MessageUnpacker unpacker = MessagePack.newDefaultUnpacker(packed);
			return ProtocolMessage.fromMsgpack(unpacker);
		} catch (IOException ioe) {
			throw AblyException.fromIOException(ioe);
		}
	}

	/****************************************
	 *            Msgpack encode
	 ****************************************/
	
	public static byte[] writeMsgpack(ProtocolMessage message) {
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		MessagePacker packer = MessagePack.newDefaultPacker(out);
		try {
			message.writeMsgpack(packer);
	
			packer.flush();
			return out.toByteArray();
		} catch(IOException e) { return null; }
	}

	/****************************************
	 *              JSON decode
	 ****************************************/
	
	public static ProtocolMessage fromJSON(String packed) throws AblyException {
		return Serialisation.gson.fromJson(packed, ProtocolMessage.class);
	}

	/****************************************
	 *              JSON encode
	 ****************************************/
	
	public static byte[] writeJSON(ProtocolMessage message) throws AblyException {
		return Serialisation.gson.toJson(message).getBytes();
	}
}
