/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package in.findcode.flexseleniumdriver.component;

import in.findcode.flexseleniumdriver.FlexBaseDriver;
import in.findcode.flexseleniumdriver.common.Constants;

/**
 *
 * @author Uttesh Kumar T.H.
 */
public class ComboBox extends FlexBaseDriver {

    public String selectByLabel(final String objectId, final String label) {
        return call(Constants.JSFunction.SELECT_COMBO_BY_LABEL_FN, objectId, label);
    }

    public String selectByLabel(final String objectId) {
        return click(objectId, Constants.EMPTY_STRING);
    }

    public String getSelectedItem(String comboBoxId) {
        return call(Constants.JSFunction.GET_SELECTION, comboBoxId, Constants.EMPTY_STRING);
    }

    public boolean isLabelInData(final String comboBoxId, final String expectedLabel) {
        return "true".equals(call(Constants.JSFunction.GET_COMBO_CONTAINS_LABEL, comboBoxId, expectedLabel));
    }
}
