/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.web.handler.sockjs.processor;

import com.google.common.base.Strings;
import io.reactivex.Single;
import io.vertx.ext.bridge.BridgeEventType;
import io.vertx.reactivex.ext.web.handler.sockjs.BridgeEventContext;
import io.vertx.reactivex.ext.web.handler.sockjs.processor.BridgeEventProcessor;
import io.vertx.reactivex.redis.RedisClient;
import org.apache.logging.log4j.Logger;

public class SubscriberCountProcessor
implements BridgeEventProcessor {
    private RedisClient mRedisClient;
    private long mCounterExpire;
    private boolean mEnable;
    private String mKeyPrefix;
    private Logger mLog;

    public RedisClient getRedisClient() {
        return this.mRedisClient;
    }

    public void setRedisClient(RedisClient pRedisClient) {
        this.mRedisClient = pRedisClient;
    }

    public long getCounterExpire() {
        return this.mCounterExpire;
    }

    public void setCounterExpire(long pCounterExpire) {
        this.mCounterExpire = pCounterExpire;
    }

    @Override
    public Single<BridgeEventContext> process(Single<BridgeEventContext> pContext) {
        if (!this.isEnable()) {
            return pContext;
        }
        return pContext.flatMap(ctx -> {
            if (ctx.getBridgeEvent().future().failed()) {
                return Single.just((Object)ctx);
            }
            if (Strings.isNullOrEmpty((String)ctx.getAddress())) {
                this.getLog().error(() -> String.format("[%s] Address can't empty", ctx.getId() != null ? ctx.getId() : ""));
                return Single.just((Object)ctx);
            }
            if (ctx.getBridgeEvent().type() == BridgeEventType.REGISTER) {
                this.getLog().debug(() -> String.format("[%s] Processing [%s] Type", ctx.getId(), ctx.getBridgeEvent().type().toString()));
                return this.mRedisClient.rxIncr(ctx.getAddressKey()).flatMap(i -> {
                    this.getLog().debug(() -> String.format("[%s] Incremented Key:[%s],Value:[%d]", ctx.getId(), ctx.getAddressKey(), i));
                    return this.mRedisClient.rxExpire(ctx.getAddressKey(), this.getCounterExpire());
                }).doOnSuccess(t -> this.getLog().debug(() -> String.format("[%s] Expiry Set Key:[%s],Time:[%d] during REGISTER", ctx.getId(), ctx.getAddressKey(), this.getCounterExpire()))).map(count -> ctx);
            }
            if (ctx.getBridgeEvent().type() == BridgeEventType.UNREGISTER) {
                this.getLog().debug(() -> String.format("[%s] Processing [%s] Type", ctx.getId(), ctx.getBridgeEvent().type().toString()));
                return this.mRedisClient.rxDecr(ctx.getAddressKey()).flatMap(i -> {
                    this.getLog().debug(() -> String.format("[%s] Decremented Key:[%s],Value:[%d]", ctx.getId(), ctx.getAddressKey(), i));
                    return this.mRedisClient.rxExpire(ctx.getAddressKey(), this.getCounterExpire());
                }).doOnSuccess(t -> this.getLog().debug(() -> String.format("[%s] Expiry Set Key:[%s],Time:[%d] during UNREGISTER", ctx.getId(), ctx.getAddressKey(), this.getCounterExpire()))).map(count -> ctx);
            }
            return Single.just((Object)ctx);
        });
    }

    public boolean isEnable() {
        return this.mEnable;
    }

    public void setEnable(boolean pEnable) {
        this.mEnable = pEnable;
    }

    public String getKeyPrefix() {
        return this.mKeyPrefix;
    }

    public void setKeyPrefix(String pKeyPrefix) {
        this.mKeyPrefix = pKeyPrefix;
    }

    public Logger getLog() {
        return this.mLog;
    }

    public void setLog(Logger pLog) {
        this.mLog = pLog;
    }
}

