/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.web.handler.sockjs.processor;

import io.reactivex.Single;
import io.vertx.core.json.JsonObject;
import io.vertx.reactivex.ext.web.handler.sockjs.BridgeEventContext;
import io.vertx.reactivex.ext.web.handler.sockjs.processor.BridgeEventProcessor;
import org.apache.logging.log4j.Logger;

public class LoadAddressProcessor
implements BridgeEventProcessor {
    private Logger mLog;

    @Override
    public Single<BridgeEventContext> process(Single<BridgeEventContext> pContext) {
        return pContext.map(ctx -> {
            if (ctx.getBridgeEvent().future().failed()) {
                return ctx;
            }
            JsonObject rawMessage = ctx.getBridgeEvent().getRawMessage();
            if (rawMessage != null) {
                ctx.setAddress(rawMessage.getString("address"));
                this.getLog().debug(() -> String.format("[%s] Address:[%s]", ctx.getId(), ctx.getAddress()));
            }
            return ctx;
        });
    }

    public Logger getLog() {
        return this.mLog;
    }

    public void setLog(Logger pLog) {
        this.mLog = pLog;
    }
}

