/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.web.handler.sockjs.processor;

import com.google.common.base.Strings;
import io.reactivex.Single;
import io.vertx.reactivex.ext.web.handler.sockjs.BridgeEventContext;
import io.vertx.reactivex.ext.web.handler.sockjs.processor.BridgeEventProcessor;
import org.apache.logging.log4j.Logger;

public class LoadAddressKeyProcessor
implements BridgeEventProcessor {
    private String mKeyPrefix;
    private Logger mLog;

    @Override
    public Single<BridgeEventContext> process(Single<BridgeEventContext> pContext) {
        return pContext.map(ctx -> {
            if (ctx.getBridgeEvent().future().failed()) {
                return ctx;
            }
            if (Strings.isNullOrEmpty((String)ctx.getAddress())) {
                this.getLog().error(() -> String.format("[%s] Address can't empty", ctx.getId() != null ? ctx.getId() : ""));
                return ctx;
            }
            ctx.setAddressKey(this.getKeyPrefix() + ctx.getAddress());
            this.getLog().debug(() -> String.format("[%s] AddressKey:[%s]", ctx.getId(), ctx.getAddressKey()));
            return ctx;
        });
    }

    public String getKeyPrefix() {
        return this.mKeyPrefix;
    }

    public void setKeyPrefix(String pKeyPrefix) {
        this.mKeyPrefix = pKeyPrefix;
    }

    public Logger getLog() {
        return this.mLog;
    }

    public void setLog(Logger pLog) {
        this.mLog = pLog;
    }
}

