/*
 * Decompiled with CFR 0.152.
 */
package in.erail.service;

import com.google.common.net.MediaType;
import in.erail.glue.annotation.StartService;
import in.erail.model.Event;
import in.erail.model.RequestEvent;
import in.erail.model.ResponseEvent;
import in.erail.service.CustomException;
import in.erail.service.RESTService;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.MaybeTransformer;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.schedulers.Schedulers;
import io.vertx.core.json.JsonObject;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.eventbus.Message;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.Logger;

public abstract class RESTServiceImpl
implements RESTService,
MaybeTransformer<Event, Event> {
    private String mOperationId;
    private String mServiceUniqueId;
    private Vertx mVertx;
    private boolean mEnable = false;
    private Logger mLog;
    private Scheduler mScheduler = Schedulers.io();
    private Event mDefaultEvent;
    private boolean mSecure = false;
    private String[] mAuthority;
    private Class<? extends RequestEvent> mRequestEventClass = RequestEvent.class;
    private Class<? extends ResponseEvent> mResponseEventClass = ResponseEvent.class;
    private MaybeTransformer<Event, Event>[] mPreProcessProcessors;
    private MaybeTransformer<Event, Event>[] mPostProcessProcessors;

    @StartService
    public void start() throws InstantiationException, IllegalAccessException {
        this.mDefaultEvent = new Event(this.getRequestEventClass().newInstance(), this.getResponseEventClass().newInstance());
        if (this.mEnable) {
            this.getVertx().eventBus().consumer(this.getServiceUniqueId()).toFlowable().observeOn(this.getScheduler()).flatMapSingle(this::handleRequest).doOnSubscribe(s -> this.getLog().info(() -> String.format("%s[%s] service started", this.getServiceUniqueId(), Thread.currentThread().getName()))).doOnTerminate(() -> this.getLog().info(() -> String.format("%s[%s] service stopped", this.getServiceUniqueId(), Thread.currentThread().getName()))).doOnCancel(() -> this.getLog().info(() -> String.format("%s[%s] service stopped(cancel)", this.getServiceUniqueId(), Thread.currentThread().getName()))).doOnComplete(() -> this.getLog().info(() -> String.format("%s[%s] service stopped(complete)", this.getServiceUniqueId(), Thread.currentThread().getName()))).subscribe(resp -> this.getLog().trace(() -> resp.toString()));
        }
    }

    public Single<JsonObject> handleRequest(Message<JsonObject> pMessage) {
        return Single.just(pMessage).map(m -> (RequestEvent)((JsonObject)pMessage.body()).mapTo(this.getRequestEventClass())).map(this::createEvent).flatMapMaybe(this::handleEvent).toSingle((Object)this.getDefaultEvent()).map(resp -> JsonObject.mapFrom((Object)resp.getResponse())).doOnSuccess(resp -> pMessage.reply(resp)).doOnError(err -> {
            ResponseEvent resp = this.getResponseEventClass().newInstance();
            if (CustomException.class.isAssignableFrom(err.getClass())) {
                CustomException cerr = (CustomException)((Object)err);
                String msg = Optional.ofNullable(err.getMessage()).orElse("");
                resp.setBody(msg.getBytes()).setMediaType(cerr.getMediaType()).setStatusCode(cerr.getStatusCode());
            } else {
                resp.setBody(ExceptionUtils.getMessage((Throwable)err).getBytes()).setMediaType(MediaType.PLAIN_TEXT_UTF_8).setStatusCode(HttpResponseStatus.BAD_REQUEST.code());
            }
            pMessage.reply((Object)JsonObject.mapFrom((Object)resp));
        }).doOnError(oerr -> this.getLog().error(() -> String.format("Process exception:[%s],Error:[%s]", this.getServiceUniqueId(), ExceptionUtils.getStackTrace((Throwable)oerr)))).onErrorReturnItem((Object)new JsonObject());
    }

    @Override
    public Maybe<Event> handleEvent(Event pEvent) {
        return Maybe.just((Object)pEvent).compose(this.composePipeline(this.getPreProcessProcessors())).compose((MaybeTransformer)this).compose(this.composePipeline(this.getPostProcessProcessors()));
    }

    protected MaybeTransformer<Event, Event> composePipeline(MaybeTransformer<Event, Event>[] pProcessors) {
        if (pProcessors == null || pProcessors.length == 0) {
            return pEvent -> pEvent;
        }
        return pEvent -> (MaybeSource)Arrays.stream(pProcessors).reduce(pEvent, (acc, p) -> acc.compose(p), (a, b) -> a);
    }

    public final MaybeSource<Event> apply(Maybe<Event> pRequest) {
        return this.process(pRequest);
    }

    public abstract MaybeSource<Event> process(Maybe<Event> var1);

    @Override
    public String getOperationId() {
        return this.mOperationId;
    }

    @Override
    public String getServiceUniqueId() {
        return this.mServiceUniqueId;
    }

    public void setOperationId(String pOperationId) {
        this.mOperationId = pOperationId;
    }

    public void setServiceUniqueId(String pServiceUniqueId) {
        this.mServiceUniqueId = pServiceUniqueId;
    }

    public Vertx getVertx() {
        return this.mVertx;
    }

    public void setVertx(Vertx pVertx) {
        this.mVertx = pVertx;
    }

    public boolean isEnable() {
        return this.mEnable;
    }

    public void setEnable(boolean pEnable) {
        this.mEnable = pEnable;
    }

    public Logger getLog() {
        return this.mLog;
    }

    public void setLog(Logger pLog) {
        this.mLog = pLog;
    }

    public Scheduler getScheduler() {
        return this.mScheduler;
    }

    public void setScheduler(Scheduler pScheduler) {
        this.mScheduler = pScheduler;
    }

    public Event getDefaultEvent() {
        return this.mDefaultEvent;
    }

    public void setDefaultEvent(Event pDefaultEvent) {
        this.mDefaultEvent = pDefaultEvent;
    }

    @Override
    public boolean isSecure() {
        return this.mSecure;
    }

    public void setSecure(boolean pSecure) {
        this.mSecure = pSecure;
    }

    @Override
    public String[] getAuthority() {
        return this.mAuthority;
    }

    public void setAuthority(String[] pAuthority) {
        this.mAuthority = pAuthority;
    }

    @Override
    public Class<? extends RequestEvent> getRequestEventClass() {
        return this.mRequestEventClass;
    }

    public void setRequestEventClass(Class<? extends RequestEvent> pRequestEventClass) {
        this.mRequestEventClass = pRequestEventClass;
    }

    @Override
    public Class<? extends ResponseEvent> getResponseEventClass() {
        return this.mResponseEventClass;
    }

    public void setResponseEventClass(Class<? extends ResponseEvent> pResponseEventClass) {
        this.mResponseEventClass = pResponseEventClass;
    }

    public MaybeTransformer<Event, Event>[] getPreProcessProcessors() {
        return this.mPreProcessProcessors;
    }

    public void setPreProcessProcessors(MaybeTransformer<Event, Event>[] pPreProcessProcessors) {
        this.mPreProcessProcessors = pPreProcessProcessors;
    }

    public MaybeTransformer<Event, Event>[] getPostProcessProcessors() {
        return this.mPostProcessProcessors;
    }

    public void setPostProcessProcessors(MaybeTransformer<Event, Event>[] pPostProcessProcessors) {
        this.mPostProcessProcessors = pPostProcessProcessors;
    }
}

