/*
 * Decompiled with CFR 0.152.
 */
package in.erail.service;

import in.erail.glue.annotation.StartService;
import in.erail.service.SingletonService;
import io.reactivex.Completable;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeListener;
import io.vertx.reactivex.core.Vertx;
import java.util.Optional;
import org.apache.logging.log4j.Logger;

public abstract class SingletonServiceImpl
implements NodeListener,
SingletonService {
    private Vertx mVertx;
    private String mServiceMapName = "__in.erail.services";
    private String mServiceName;
    private ClusterManager mClusterManager;
    private Logger mLog;
    private boolean mEnable;

    @StartService
    public void start() {
        if (!this.isEnable()) {
            return;
        }
        Single.just(Optional.empty()).flatMapCompletable(this::init).subscribe();
    }

    protected Completable init(Optional<String> pOldNodeID) {
        String serviceName = this.getServiceName();
        String thisNodeId = this.getClusterManager().getNodeID();
        return Single.just((Object)this.getServiceMapName()).flatMap(name -> this.getVertx().sharedData().rxGetClusterWideMap(name)).flatMap(m -> {
            if (pOldNodeID.isPresent()) {
                return m.rxReplaceIfPresent((Object)this.getServiceName(), (Object)((String)pOldNodeID.get()), (Object)thisNodeId).map(v -> v != false ? thisNodeId : "");
            }
            return m.rxPutIfAbsent((Object)serviceName, (Object)thisNodeId).switchIfEmpty((SingleSource)Single.just((Object)thisNodeId));
        }).doOnSuccess(serviceOwnerId -> this.getLog().debug(() -> "Service Owner ID:" + serviceOwnerId + ", This Node ID:" + thisNodeId)).map(serviceOwnerId -> thisNodeId.equals(serviceOwnerId)).doOnSuccess(t -> this.getLog().debug(() -> "Service Start Decision:" + this.getServiceName() + ":" + t)).flatMapCompletable(success -> {
            if (success.booleanValue()) {
                this.getLog().info(String.format("Starting Service:[%s]", this.getServiceName()));
                return this.startService().doOnComplete(() -> this.getLog().info(String.format("Service:[%s] started", this.getServiceName())));
            }
            return Completable.complete();
        });
    }

    public void nodeAdded(String pNodeID) {
    }

    public void nodeLeft(String pNodeID) {
        if (!this.isEnable()) {
            return;
        }
        Single.just(Optional.of(pNodeID)).flatMapCompletable(this::init).subscribe();
    }

    public Vertx getVertx() {
        return this.mVertx;
    }

    public void setVertx(Vertx pVertx) {
        this.mVertx = pVertx;
    }

    public String getServiceMapName() {
        return this.mServiceMapName;
    }

    public void setServiceMapName(String pServiceMapName) {
        this.mServiceMapName = pServiceMapName;
    }

    public String getServiceName() {
        return this.mServiceName;
    }

    public void setServiceName(String pServiceName) {
        this.mServiceName = pServiceName;
    }

    public ClusterManager getClusterManager() {
        return this.mClusterManager;
    }

    public void setClusterManager(ClusterManager pClusterManager) {
        this.mClusterManager = pClusterManager;
    }

    public Logger getLog() {
        return this.mLog;
    }

    public void setLog(Logger pLog) {
        this.mLog = pLog;
    }

    public boolean isEnable() {
        return this.mEnable;
    }

    public void setEnable(boolean pEnable) {
        this.mEnable = pEnable;
    }
}

