/*
 * Decompiled with CFR 0.152.
 */
package in.erail.scheduler;

import in.erail.glue.annotation.StartService;
import in.erail.scheduler.QuartzJob;
import in.erail.scheduler.QuartzScheduledJob;
import java.util.Properties;
import java.util.UUID;
import org.apache.logging.log4j.Logger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzScheduler {
    private Properties mConfig;
    private Scheduler mScheduler;
    private Logger mLog;
    private boolean mEnable;

    @StartService
    public void start() throws SchedulerException {
        this.mScheduler = new StdSchedulerFactory(this.getConfig()).getScheduler();
        if (this.mEnable) {
            this.mScheduler.start();
            this.getLog().info("Scheduler Started");
        }
    }

    public String addScheduledJob(QuartzScheduledJob pScheduledJob) {
        String uuid = UUID.randomUUID().toString();
        JobKey jobKey = new JobKey(uuid, pScheduledJob.getJobName());
        TriggerKey tirggerKey = new TriggerKey(uuid, pScheduledJob.getJobName());
        QuartzJob job = pScheduledJob.getJob();
        JobDetail jobDetails = JobBuilder.newJob(job.getClass()).withDescription(pScheduledJob.getJobDescription()).withIdentity(jobKey).usingJobData("_comp", job.getGlueMountPath()).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(tirggerKey).startNow().withSchedule(pScheduledJob.getScheduleBuilder()).usingJobData("_comp", job.getGlueMountPath()).build();
        try {
            this.mScheduler.scheduleJob(jobDetails, trigger);
            this.getLog().debug(() -> "Added Job:" + jobKey.toString());
        }
        catch (SchedulerException ex) {
            this.getLog().error((Object)ex);
        }
        return jobKey.toString();
    }

    public Properties getConfig() {
        return this.mConfig;
    }

    public void setConfig(Properties pConfig) {
        this.mConfig = pConfig;
    }

    public Logger getLog() {
        return this.mLog;
    }

    public void setLog(Logger pLog) {
        this.mLog = pLog;
    }

    public boolean isEnable() {
        return this.mEnable;
    }

    public void setEnable(boolean pEnable) {
        this.mEnable = pEnable;
    }

    public Scheduler getScheduler() {
        return this.mScheduler;
    }
}

