/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence;

import io.reactivex.Single;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import org.apache.logging.log4j.Logger;

public class EntityManagerHelper {
    private EntityManagerFactory mEntityManagerFactory;
    private Logger mLog;

    public Single<EntityManager> getEM() {
        return Single.using(() -> this.getEntityManagerFactory().createEntityManager(), em -> Single.just((Object)em), em -> em.close(), (boolean)false);
    }

    public Single<EntityManager> getEMTx() {
        return Single.using(() -> this.getEntityManagerFactory().createEntityManager(), em -> {
            em.getTransaction().begin();
            return Single.just((Object)em);
        }, em -> {
            EntityTransaction tx = em.getTransaction();
            if (tx.isActive()) {
                this.getLog().error("Resource leakage: Entity Manager tx not finished. Rolling back tx");
                tx.rollback();
            }
            em.close();
        }, (boolean)false);
    }

    public Logger getLog() {
        return this.mLog;
    }

    public void setLog(Logger pLog) {
        this.mLog = pLog;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.mEntityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory pEntityManagerFactory) {
        this.mEntityManagerFactory = pEntityManagerFactory;
    }
}

