/*
 * Decompiled with CFR 0.152.
 */
package in.erail.security;

import in.erail.glue.annotation.StartService;
import io.reactivex.Single;
import io.vertx.reactivex.core.Vertx;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.Logger;

public class SecurityTools {
    private Logger mLog;
    private Vertx mVertx;
    private SecureRandom mRandom;
    private final CompletableFuture<SecretKeySpec> mKeySpec = new CompletableFuture();
    private final CompletableFuture<String> mGlobalUniqueString = new CompletableFuture();

    @StartService
    public void startup() {
        this.setRandom(new SecureRandom());
        if (this.getVertx().isClustered()) {
            byte[] key = this.generateKey().get();
            this.addValueToClusterMap("key", key).subscribe(k -> {
                String unique = Base64.getEncoder().encodeToString(Arrays.copyOfRange(k, 0, 5));
                this.mGlobalUniqueString.complete(unique.replace("=", ""));
                this.getLog().info(() -> String.format("GlobalUniqueString:[%s]", unique));
                this.mKeySpec.complete(new SecretKeySpec((byte[])k, "AES"));
            });
        } else {
            byte[] k2 = this.generateKey().get();
            String unique = Base64.getEncoder().encodeToString(Arrays.copyOfRange(k2, 0, 5));
            this.mGlobalUniqueString.complete(unique.replace("=", ""));
            this.mKeySpec.complete(new SecretKeySpec(k2, "AES"));
        }
    }

    protected Single<byte[]> addValueToClusterMap(String pKey, byte[] pValue) {
        return this.getVertx().sharedData().rxGetClusterWideMap("_in.erail.security").flatMapMaybe(m -> m.rxPutIfAbsent((Object)pKey, (Object)pValue)).toSingle((Object)pValue);
    }

    protected Optional<byte[]> generateKey() {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance("AES");
            keygen.init(128);
            return Optional.of(keygen.generateKey().getEncoded());
        }
        catch (NoSuchAlgorithmException ex) {
            this.getLog().error((Object)ex);
            return Optional.empty();
        }
    }

    public String getGlobalUniqueString() {
        try {
            return this.mGlobalUniqueString.get();
        }
        catch (ExecutionException ex) {
            this.getLog().error("Global Unique not working", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            this.getLog().error((Object)ex);
            Thread.currentThread().interrupt();
        }
        return "ERROR_GLOBAL_KEY";
    }

    private byte[] concatenateByteArrays(byte[] a, byte[] b) {
        byte[] result = new byte[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    public String encrypt(String value) {
        try {
            byte[] riv = new byte[16];
            this.mRandom.nextBytes(riv);
            IvParameterSpec iv = new IvParameterSpec(riv);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            cipher.init(1, (Key)this.getKeySpec(), iv);
            byte[] encrypted = cipher.doFinal(value.getBytes());
            return Base64.getEncoder().encodeToString(this.concatenateByteArrays(encrypted, riv));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | ExecutionException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            this.getLog().error((Object)ex);
        }
        catch (InterruptedException ex) {
            this.getLog().error((Object)ex);
            Thread.currentThread().interrupt();
        }
        return null;
    }

    public String decrypt(String encrypted) {
        try {
            byte[] data = Base64.getDecoder().decode(encrypted);
            IvParameterSpec iv = new IvParameterSpec(data, data.length - 16, 16);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            cipher.init(2, (Key)this.getKeySpec(), iv);
            byte[] original = cipher.doFinal(data, 0, data.length - 16);
            return new String(original);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | ExecutionException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException ex) {
            this.getLog().error((Object)ex);
        }
        catch (InterruptedException ex) {
            this.getLog().error((Object)ex);
            Thread.currentThread().interrupt();
        }
        return null;
    }

    public Logger getLog() {
        return this.mLog;
    }

    public void setLog(Logger pLog) {
        this.mLog = pLog;
    }

    public SecureRandom getRandom() {
        return this.mRandom;
    }

    public void setRandom(SecureRandom pRandom) {
        this.mRandom = pRandom;
    }

    public SecretKeySpec getKeySpec() throws InterruptedException, ExecutionException {
        return this.mKeySpec.get();
    }

    public Vertx getVertx() {
        return this.mVertx;
    }

    public void setVertx(Vertx pVertx) {
        this.mVertx = pVertx;
    }
}

