/*
 * Decompiled with CFR 0.152.
 */
package in.erail.route;

import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.net.MediaType;
import in.erail.glue.annotation.StartService;
import in.erail.route.AbstractRouterBuilderImpl;
import in.erail.service.RESTService;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.reactivex.core.MultiMap;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.eventbus.Message;
import io.vertx.reactivex.core.http.HttpServerResponse;
import io.vertx.reactivex.ext.web.Cookie;
import io.vertx.reactivex.ext.web.Router;
import io.vertx.reactivex.ext.web.RoutingContext;
import io.vertx.reactivex.ext.web.api.contract.openapi3.OpenAPI3RouterFactory;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class OpenAPI3RouteBuilder
extends AbstractRouterBuilderImpl {
    private static final String AUTHORIZATION_PREFIX = "realm";
    private static final String FAIL_SUFFIX = ".fail";
    private RESTService[] mServices;
    private File mOpenAPI3File;
    private DeliveryOptions mDeliveryOptions;
    private boolean mSecurityEnable = true;
    private HashMap<String, Metered> mMetrics = new HashMap();
    private MetricRegistry mMetricRegistry;

    public File getOpenAPI3File() {
        return this.mOpenAPI3File;
    }

    public void setOpenAPI3File(File pOpenAPI3File) {
        this.mOpenAPI3File = pOpenAPI3File;
    }

    public RESTService[] getServices() {
        return this.mServices;
    }

    public void setServices(RESTService[] pServices) {
        this.mServices = pServices;
    }

    @StartService
    public void start() {
        Arrays.stream(this.getServices()).forEach(service -> {
            this.getMetrics().put(service.getServiceUniqueId(), (Metered)this.getMetricRegistry().timer("api.framework.service." + service.getServiceUniqueId()));
            this.getMetrics().put(service.getServiceUniqueId() + FAIL_SUFFIX, (Metered)this.getMetricRegistry().meter("api.framework.service." + service.getServiceUniqueId() + FAIL_SUFFIX));
        });
    }

    public void process(RoutingContext pRequestContext, String pServiceUniqueId) {
        Timer.Context timerCtx = ((Timer)this.getMetrics().get(pServiceUniqueId)).time();
        this.getVertx().eventBus().send(pServiceUniqueId, (Object)this.serialiseRoutingContext(pRequestContext), this.getDeliveryOptions(), reply -> {
            if (reply.succeeded()) {
                JsonObject response = (JsonObject)((Message)reply.result()).body();
                this.buildResponseFromReply(response, pRequestContext).end();
            } else {
                ((Meter)this.getMetrics().get(pServiceUniqueId + FAIL_SUFFIX)).mark();
                this.getLog().error(() -> "Error in reply:" + reply.cause().toString());
                pRequestContext.response().setStatusCode(400).end(reply.cause().toString());
            }
            timerCtx.stop();
        });
    }

    public JsonObject serialiseRoutingContext(RoutingContext pContext) {
        JsonObject result = new JsonObject();
        if (pContext.request().method() == HttpMethod.POST) {
            result.put("body", pContext.getBody().getDelegate().getBytes());
        } else {
            result.put("body", new byte[0]);
        }
        JsonObject headers = new JsonObject(this.convertMultiMapIntoMap(pContext.request().headers()));
        result.put("headers", headers);
        JsonObject query = new JsonObject(this.convertMultiMapIntoMap(pContext.queryParams()));
        result.put("queryStringParameters", query);
        JsonObject params = new JsonObject(this.convertMultiMapIntoMap(pContext.request().params()));
        result.put("pathParameters", params);
        this.getLog().debug(() -> "Context to JSON:" + result.toString());
        return result;
    }

    public HttpServerResponse buildResponseFromReply(JsonObject pReplyResponse, RoutingContext pContext) {
        Optional<Object> body;
        JsonObject headers = pReplyResponse.getJsonObject("headers", new JsonObject());
        String statusCode = pReplyResponse.getString("statusCode", HttpResponseStatus.OK.codeAsText().toString());
        if (!headers.containsKey("Content-Type")) {
            headers.put("Content-Type", MediaType.OCTET_STREAM.toString());
        }
        headers.fieldNames().stream().forEach(field -> pContext.response().putHeader(field, headers.getString(field, "")));
        pContext.response().setStatusCode(HttpResponseStatus.parseLine((CharSequence)statusCode).code());
        Optional<JsonArray> cookies = Optional.ofNullable(pReplyResponse.getJsonArray("cookies"));
        cookies.ifPresent(cooky -> {
            for (JsonObject next : cooky) {
                Optional<String> cookieName = Optional.ofNullable(next.getString("name"));
                if (!cookieName.isPresent()) continue;
                Cookie c = Cookie.cookie((String)cookieName.get(), (String)"");
                Optional.ofNullable(next.getString("value")).ifPresent(t -> c.setValue(t));
                Optional.ofNullable(next.getString("path")).ifPresent(t -> c.setPath(t));
                Optional.ofNullable(next.getDouble("maxAge")).ifPresent(t -> c.setMaxAge(t.longValue()));
                Optional.ofNullable(next.getString("domain")).ifPresent(t -> c.setDomain(t));
                Optional.ofNullable(next.getBoolean("secure")).ifPresent(t -> c.setSecure(t.booleanValue()));
                Optional.ofNullable(next.getBoolean("httpOnly")).ifPresent(t -> c.setHttpOnly(t.booleanValue()));
                pContext.addCookie(c);
            }
        });
        try {
            body = Optional.ofNullable(pReplyResponse.getBinary("body"));
        }
        catch (IllegalArgumentException e) {
            this.getLog().error(() -> "Could not get message body as binary. Please check if service is sending body in binary." + pContext.request().absoluteURI() + ":" + e.toString());
            body = Optional.empty();
        }
        body.ifPresent(t -> {
            pContext.response().putHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), Integer.toString(((byte[])t).length));
            pContext.response().write(io.vertx.reactivex.core.buffer.Buffer.newInstance((Buffer)Buffer.buffer((byte[])t)));
        });
        return pContext.response();
    }

    public Map<String, Object> convertMultiMapIntoMap(MultiMap pMultiMap) {
        return pMultiMap.getDelegate().entries().stream().collect(Collectors.toMap(t -> (String)t.getKey(), t -> (String)t.getValue(), (a, b) -> a));
    }

    public DeliveryOptions getDeliveryOptions() {
        return this.mDeliveryOptions;
    }

    public void setDeliveryOptions(DeliveryOptions pDeliveryOptions) {
        this.mDeliveryOptions = pDeliveryOptions;
    }

    @Override
    public Router getRouter(Router pRouter) {
        OpenAPI3RouterFactory apiFactory = (OpenAPI3RouterFactory)OpenAPI3RouterFactory.rxCreateRouterFactoryFromFile((Vertx)this.getVertx(), (String)this.getOpenAPI3File().getAbsolutePath()).blockingGet();
        Optional.ofNullable(this.getServices()).ifPresent(t -> Arrays.asList(t).stream().forEach(service -> apiFactory.addHandlerByOperationId(service.getOperationId(), routingContext -> {
            if (this.isSecurityEnable()) {
                if (routingContext.user() == null) {
                    routingContext.fail(401);
                    return;
                }
                routingContext.user().isAuthorized("realm:" + service.getOperationId(), event -> {
                    boolean authSuccess;
                    boolean bl = authSuccess = event.succeeded() ? (Boolean)event.result() : false;
                    if (authSuccess) {
                        this.process((RoutingContext)routingContext, service.getServiceUniqueId());
                    } else {
                        routingContext.fail(401);
                    }
                });
            } else {
                this.getLog().warn("Security disabled for " + service.getServiceUniqueId());
                this.process((RoutingContext)routingContext, service.getServiceUniqueId());
            }
        })));
        return apiFactory.getRouter();
    }

    public boolean isSecurityEnable() {
        return this.mSecurityEnable;
    }

    public void setSecurityEnable(boolean pSecurityEnable) {
        this.mSecurityEnable = pSecurityEnable;
    }

    public void setOpenAPI3JSON(JsonObject pOpenAPI3JSON) {
        try {
            File f = File.createTempFile("openapi3json", null);
            this.getVertx().getDelegate().fileSystem().writeFileBlocking(f.getAbsolutePath(), pOpenAPI3JSON.toBuffer());
            this.setOpenAPI3File(f);
        }
        catch (IOException ex) {
            this.getLog().error((Object)ex);
        }
    }

    public HashMap<String, Metered> getMetrics() {
        return this.mMetrics;
    }

    public void setMetrics(HashMap<String, Metered> pMetrics) {
        this.mMetrics = pMetrics;
    }

    public MetricRegistry getMetricRegistry() {
        return this.mMetricRegistry;
    }

    public void setMetricRegistry(MetricRegistry pMetricRegistry) {
        this.mMetricRegistry = pMetricRegistry;
    }
}

