/*
 * Decompiled with CFR 0.152.
 */
package in.erail.service;

import in.erail.glue.annotation.StartService;
import in.erail.service.SingletonService;
import io.reactivex.Completable;
import io.reactivex.schedulers.Schedulers;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeListener;
import io.vertx.reactivex.core.Vertx;
import org.apache.logging.log4j.Logger;

public abstract class SingletonServiceImpl
implements NodeListener,
SingletonService {
    private Vertx mVertx;
    private String mServiceMapName = "__in.erail.services";
    private String mServiceName;
    private ClusterManager mClusterManager;
    private Logger mLog;
    private boolean mEnable;

    @StartService
    public void start() {
        if (!this.isEnable()) {
            return;
        }
        this.getVertx().sharedData().rxGetClusterWideMap(this.getServiceMapName()).subscribeOn(Schedulers.io()).flatMap(m -> m.rxPutIfAbsent((Object)this.getServiceName(), (Object)this.getClusterManager().getNodeID())).map(ownerNodeId -> {
            if (ownerNodeId == null) {
                return true;
            }
            return this.getClusterManager().getNodeID().equals(ownerNodeId);
        }).flatMapCompletable(success -> {
            if (success.booleanValue()) {
                this.getLog().info(String.format("Starting Service:[%s]", this.getServiceName()));
                return this.startService().doOnComplete(() -> this.getLog().info(String.format("Service:[%s] started", this.getServiceName())));
            }
            return Completable.complete();
        }).blockingAwait();
    }

    public void nodeAdded(String pNodeID) {
    }

    public void nodeLeft(String pNodeID) {
        if (!this.isEnable()) {
            return;
        }
        this.getVertx().sharedData().rxGetClusterWideMap(this.getServiceMapName()).subscribeOn(Schedulers.io()).flatMap(m -> m.rxReplaceIfPresent((Object)this.getServiceName(), (Object)pNodeID, (Object)this.getClusterManager().getNodeID())).flatMapCompletable(success -> {
            if (success.booleanValue()) {
                this.getLog().info(String.format("Starting Service:[%s] becuase of cluster state update", this.getServiceName()));
                return this.startService().doOnComplete(() -> this.getLog().info(String.format("Service:[%s] start complete because of cluster state update", this.getServiceName())));
            }
            return Completable.complete();
        }).blockingAwait();
    }

    public Vertx getVertx() {
        return this.mVertx;
    }

    public void setVertx(Vertx pVertx) {
        this.mVertx = pVertx;
    }

    public String getServiceMapName() {
        return this.mServiceMapName;
    }

    public void setServiceMapName(String pServiceMapName) {
        this.mServiceMapName = pServiceMapName;
    }

    public String getServiceName() {
        return this.mServiceName;
    }

    public void setServiceName(String pServiceName) {
        this.mServiceName = pServiceName;
    }

    public ClusterManager getClusterManager() {
        return this.mClusterManager;
    }

    public void setClusterManager(ClusterManager pClusterManager) {
        this.mClusterManager = pClusterManager;
    }

    public Logger getLog() {
        return this.mLog;
    }

    public void setLog(Logger pLog) {
        this.mLog = pLog;
    }

    public boolean isEnable() {
        return this.mEnable;
    }

    public void setEnable(boolean pEnable) {
        this.mEnable = pEnable;
    }
}

