/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core;

import in.erail.glue.annotation.StartService;
import in.erail.glue.component.ServiceArray;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Verticle;
import io.vertx.core.json.JsonObject;
import io.vertx.reactivex.core.Vertx;
import java.util.Arrays;
import org.apache.logging.log4j.Logger;

public class VerticalDeployer {
    private String[] mVerticalNames;
    private ServiceArray mVerticalInstances;
    private DeploymentOptions mDeploymentOptions;
    private Vertx mVertx;
    private Logger mLog;
    private String mDeployStatusTopicName;

    @StartService
    public void start() {
        Arrays.stream(this.getVerticalNames()).forEach(path -> {
            JsonObject deployMsg = new JsonObject();
            deployMsg.put("name", path);
            this.getVertx().getDelegate().deployVerticle(path, this.getDeploymentOptions(), result -> {
                if (result.succeeded()) {
                    String deploymentId = (String)result.result();
                    deployMsg.put("deploymentId", deploymentId);
                    deployMsg.put("success", Boolean.valueOf(true));
                    this.getVertx().eventBus().publish(this.getDeployStatusTopicName(), (Object)deployMsg);
                    this.getLog().info(() -> "Deployed:" + path + ":" + deploymentId);
                } else {
                    deployMsg.put("success", Boolean.valueOf(false));
                    this.getVertx().eventBus().publish(this.getDeployStatusTopicName(), (Object)deployMsg);
                    this.getLog().error("Vertical Deployment failed", result.cause());
                }
            });
        });
        this.getVerticalInstances().getServices().stream().forEach(vertical -> {
            JsonObject deployMsg = new JsonObject();
            deployMsg.put("name", vertical.getClass().getCanonicalName());
            this.getVertx().getDelegate().deployVerticle((Verticle)vertical, this.getDeploymentOptions(), result -> {
                if (result.succeeded()) {
                    String deploymentId = (String)result.result();
                    deployMsg.put("deploymentId", deploymentId);
                    deployMsg.put("success", Boolean.valueOf(true));
                    this.getVertx().eventBus().publish(this.getDeployStatusTopicName(), (Object)deployMsg);
                    this.getLog().info(() -> "Deployed:" + vertical.getClass().getCanonicalName() + ":" + deploymentId);
                } else {
                    deployMsg.put("success", Boolean.valueOf(false));
                    this.getVertx().eventBus().publish(this.getDeployStatusTopicName(), (Object)deployMsg);
                    this.getLog().error("Vertical Deployment failed", result.cause());
                }
            });
        });
    }

    public String[] getVerticalNames() {
        return this.mVerticalNames;
    }

    public void setVerticalNames(String[] pVerticalNames) {
        this.mVerticalNames = pVerticalNames;
    }

    public DeploymentOptions getDeploymentOptions() {
        return this.mDeploymentOptions;
    }

    public void setDeploymentOptions(DeploymentOptions pDeploymentOptions) {
        this.mDeploymentOptions = pDeploymentOptions;
    }

    public Vertx getVertx() {
        return this.mVertx;
    }

    public void setVertx(Vertx pVertx) {
        this.mVertx = pVertx;
    }

    public Logger getLog() {
        return this.mLog;
    }

    public void setLog(Logger pLog) {
        this.mLog = pLog;
    }

    public String getDeployStatusTopicName() {
        return this.mDeployStatusTopicName;
    }

    public void setDeployStatusTopicName(String pDeployStatusTopicName) {
        this.mDeployStatusTopicName = pDeployStatusTopicName;
    }

    public ServiceArray getVerticalInstances() {
        return this.mVerticalInstances;
    }

    public void setVerticalInstances(ServiceArray pVerticalInstances) {
        this.mVerticalInstances = pVerticalInstances;
    }
}

