/*
 * Decompiled with CFR 0.152.
 */
package in.erail.route;

import in.erail.route.AbstractRouterBuilderImpl;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.reactivex.ext.web.Router;
import io.vertx.reactivex.ext.web.handler.CorsHandler;
import java.util.Arrays;
import java.util.Set;

public class CORSRouteBuilder
extends AbstractRouterBuilderImpl {
    private String mAllowedOrigin;
    private Set<String> mAllowedHeaders;
    private String[] mAllowedMethod;
    private int mMaxAgeSeconds;
    private boolean mAllowedCredentials;

    @Override
    public Router getRouter(Router pRouter) {
        CorsHandler crosHdl = CorsHandler.create((String)this.getAllowedOrigin());
        Arrays.stream(this.getAllowedMethod()).forEach(method -> crosHdl.allowedMethod(HttpMethod.valueOf((String)method)));
        crosHdl.allowedHeaders(this.getAllowedHeaders());
        crosHdl.maxAgeSeconds(this.getMaxAgeSeconds());
        crosHdl.allowCredentials(this.isAllowedCredentials());
        pRouter.route().handler((Handler)crosHdl);
        return pRouter;
    }

    public String getAllowedOrigin() {
        return this.mAllowedOrigin;
    }

    public void setAllowedOrigin(String pAllowedOrigin) {
        this.mAllowedOrigin = pAllowedOrigin;
    }

    public boolean isAllowedCredentials() {
        return this.mAllowedCredentials;
    }

    public void setAllowedCredentials(boolean pAllowedCredentials) {
        this.mAllowedCredentials = pAllowedCredentials;
    }

    public Set<String> getAllowedHeaders() {
        return this.mAllowedHeaders;
    }

    public void setAllowedHeaders(Set<String> pAllowedHeaders) {
        this.mAllowedHeaders = pAllowedHeaders;
    }

    public int getMaxAgeSeconds() {
        return this.mMaxAgeSeconds;
    }

    public void setMaxAgeSeconds(int pMaxAgeSeconds) {
        this.mMaxAgeSeconds = pMaxAgeSeconds;
    }

    public String[] getAllowedMethod() {
        return this.mAllowedMethod;
    }

    public void setAllowedMethod(String[] pAllowedMethod) {
        this.mAllowedMethod = pAllowedMethod;
    }
}

