/*
 * Decompiled with CFR 0.152.
 */
package in.ashwanthkumar.slack.webhook;

import in.ashwanthkumar.slack.webhook.SlackAttachment;
import in.ashwanthkumar.slack.webhook.SlackMessage;
import in.ashwanthkumar.slack.webhook.service.SlackService;
import in.ashwanthkumar.utils.collections.Lists;
import in.ashwanthkumar.utils.lang.StringUtils;
import java.io.IOException;
import java.util.List;

public class Slack {
    private String webhookUrl;
    private String channel;
    private String user;
    private String icon;
    private SlackService slackService = new SlackService();

    public Slack(String webhookUrl) {
        if (StringUtils.isEmpty((String)webhookUrl)) {
            throw new IllegalArgumentException("Webhook url is not provided");
        }
        this.webhookUrl = webhookUrl;
    }

    Slack(String webhookUrl, SlackService mockService) {
        this.webhookUrl = webhookUrl;
        this.slackService = mockService;
    }

    public Slack sendToChannel(String channel) {
        this.channel = "#" + channel;
        return this;
    }

    public Slack sendToUser(String sendToUser) {
        this.channel = "@" + sendToUser;
        return this;
    }

    public Slack displayName(String user) {
        this.user = user;
        return this;
    }

    public Slack icon(String imageOrIcon) {
        this.icon = imageOrIcon;
        return this;
    }

    public void push(SlackMessage message) throws IOException {
        if (message != null) {
            this.slackService.push(this.webhookUrl, message, this.user, this.icon, this.channel);
        }
    }

    public void push(SlackAttachment attachment) throws IOException {
        if (attachment != null) {
            this.slackService.push(this.webhookUrl, new SlackMessage(), this.user, this.icon, this.channel, Lists.of((Object[])new SlackAttachment[]{attachment}));
        }
    }

    public void push(List<SlackAttachment> attachments) throws IOException {
        this.slackService.push(this.webhookUrl, new SlackMessage(), this.user, this.icon, this.channel, attachments);
    }
}

