/*
 * Decompiled with CFR 0.152.
 */
package in.ashwanthkumar.slack.webhook;

import in.ashwanthkumar.utils.lang.StringUtils;

public class SlackMessage {
    private StringBuilder textBuffer = new StringBuilder();

    public SlackMessage() {
    }

    public SlackMessage(String text) {
        this.text(text);
    }

    public SlackMessage text(String text) {
        this.textBuffer.append(text);
        return this;
    }

    public SlackMessage link(String url) {
        this.link(url, "");
        return this;
    }

    public SlackMessage link(String url, String text) {
        if (StringUtils.isNotEmpty((String)text)) {
            this.textBuffer.append("<").append(url).append("|").append(text).append(">");
        } else {
            this.textBuffer.append("<").append(url).append(">");
        }
        return this;
    }

    public SlackMessage bold(String text) {
        this.textBuffer.append("*").append(text).append("*");
        return this;
    }

    public SlackMessage mentionUserID(String userID) {
        this.textBuffer.append("<@").append(userID).append(">");
        return this;
    }

    public SlackMessage mentionChannelID(String channelID) {
        this.textBuffer.append("<#").append(channelID).append(">");
        return this;
    }

    public SlackMessage italic(String text) {
        this.textBuffer.append("_").append(text).append("_");
        return this;
    }

    public SlackMessage code(String code) {
        this.textBuffer.append("`").append(code).append("`");
        return this;
    }

    public SlackMessage preformatted(String text) {
        this.textBuffer.append("```").append(text).append("```");
        return this;
    }

    public SlackMessage quote(String text) {
        this.textBuffer.append("\n> ").append(text).append("\n");
        return this;
    }

    public String toString() {
        return this.textBuffer.toString();
    }

    public String rawText() {
        return this.textBuffer.toString().replaceAll("(.*)\\*(.*)\\*(.*)", "$1$2$3").replaceAll("(.*)_(.*)_(.*)", "$1$2$3").replaceAll("(.*)```(.*)```(.*)", "$1$2$3").replaceAll("(.*)`(.*)`(.*)", "$1$2$3").replaceAll("\n>\\s+(.*)\n", "$1");
    }
}

