/*
 * Decompiled with CFR 0.152.
 */
package in.ashwanthkumar.slack.webhook;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import in.ashwanthkumar.slack.webhook.SlackMessage;
import in.ashwanthkumar.slack.webhook.util.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SlackService {
    private final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    private final HttpRequestFactory requestFactory = this.HTTP_TRANSPORT.createRequestFactory();

    public void push(String webHookUrl, SlackMessage text, String username, String imageOrIcon, String destination) throws IOException {
        HashMap<String, String> payload = new HashMap<String, String>();
        if (StringUtils.isNotEmpty(username)) {
            payload.put("username", username);
        }
        if (StringUtils.startsWith(imageOrIcon, "http")) {
            payload.put("icon_url", imageOrIcon);
        } else if (StringUtils.isNotEmpty(imageOrIcon)) {
            payload.put("icon_emoji", imageOrIcon);
        }
        if (StringUtils.isNotEmpty(destination)) {
            payload.put("channel", destination);
        }
        payload.put("text", text.toString());
        this.execute(webHookUrl, payload);
    }

    public void execute(String webHookUrl, Map<String, String> payload) throws IOException {
        HttpRequest httpRequest = this.requestFactory.buildPostRequest(new GenericUrl(webHookUrl), (HttpContent)new JsonHttpContent((JsonFactory)new GsonFactory(), payload));
        httpRequest.execute();
    }
}

