/*
 * Decompiled with CFR 0.152.
 */
package in.ashwanthkumar.gocd.client.http;

import com.google.api.client.http.BasicAuthentication;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.ObjectParser;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import in.ashwanthkumar.gocd.client.auth.Authentication;
import in.ashwanthkumar.gocd.client.http.GsonObjectParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static Logger LOG = LoggerFactory.getLogger(HttpClient.class);
    private static final int DEFAULT_SOCKET_TIMEOUT = 600000;
    private static final int DEFAULT_READ_TIMEOUT = 600000;
    private String mockResponse;
    private final HttpRequestFactory requestFactory;
    private final int socketTimeout;
    private final int readTimeout;
    private String serverHost;

    @Deprecated(since="0.0.8", forRemoval=true)
    public HttpClient(String username, String password, Proxy proxy, String serverHost) {
        this(username, password, proxy, 600000, 600000, serverHost);
    }

    @Deprecated(since="0.0.8", forRemoval=true)
    public HttpClient(String username, String password, String serverHost) {
        this(username, password, null, serverHost);
    }

    @Deprecated(since="0.0.8", forRemoval=true)
    public HttpClient(String username, String password, Proxy proxy, int socketTimeout, int readTimeout, String serverHost) {
        NetHttpTransport.Builder builder = new NetHttpTransport.Builder();
        if (proxy != null) {
            builder.setProxy(proxy);
        }
        NetHttpTransport transport = builder.build();
        this.requestFactory = username != null && password != null ? transport.createRequestFactory((HttpRequestInitializer)new BasicAuthentication(username, password)) : transport.createRequestFactory();
        this.socketTimeout = socketTimeout;
        this.readTimeout = readTimeout;
        this.serverHost = serverHost;
    }

    public HttpClient(Authentication authentication, String serverHost) {
        this(authentication, null, 600000, 600000, serverHost);
    }

    public HttpClient(Authentication authentication, Proxy proxy, int socketTimeout, int readTimeout, String serverHost) {
        NetHttpTransport.Builder builder = new NetHttpTransport.Builder();
        if (proxy != null) {
            builder.setProxy(proxy);
        }
        NetHttpTransport transport = builder.build();
        this.requestFactory = authentication.addAuthentication((HttpTransport)transport);
        this.socketTimeout = socketTimeout;
        this.readTimeout = readTimeout;
        this.serverHost = serverHost;
    }

    public void setMockResponse(String response) {
        this.mockResponse = response;
    }

    public JsonElement getRawJson(String resource) throws IOException {
        if (this.mockResponse != null) {
            return new JsonParser().parse(this.mockResponse);
        }
        return new JsonParser().parse(this.invokeGET(resource).execute().parseAsString());
    }

    public JsonElement getRawJson(String resource, int apiVersion) throws IOException {
        if (this.mockResponse != null) {
            return new JsonParser().parse(this.mockResponse);
        }
        return new JsonParser().parse(this.invokeGET(resource, apiVersion).execute().parseAsString());
    }

    public <T> T getAs(String resource, Class<T> responseType) throws IOException {
        return this.getAs(resource, (Type)responseType);
    }

    public <T> T getAs(String resource, Type responseType) throws IOException {
        if (this.mockResponse != null) {
            return (T)new GsonObjectParser(new Gson()).parseAndClose((Reader)new StringReader(this.mockResponse), responseType);
        }
        Object object = this.invokeGET(resource).setParser((ObjectParser)new GsonObjectParser(new Gson())).execute().parseAs(responseType);
        return (T)object;
    }

    public <T> T getAs(String resource, Class<T> responseType, int apiVersion) throws IOException {
        return this.getAs(resource, (Type)responseType, apiVersion);
    }

    public <T> T getAs(String resource, Type responseType, int apiVersion) throws IOException {
        return this.invoke(this.invokeGET(resource, apiVersion), responseType);
    }

    public <T> T patchAs(String resource, Type responseType, int apiVersion, Object payload) throws IOException {
        return this.invoke(this.invokePATCH(resource, apiVersion, payload), responseType);
    }

    public <T> T invoke(HttpRequest request, Type type) throws IOException {
        if (this.mockResponse != null) {
            return (T)new GsonObjectParser(new Gson()).parseAndClose((Reader)new StringReader(this.mockResponse), type);
        }
        Object result = request.setParser((ObjectParser)new GsonObjectParser(new Gson())).execute().parseAs(type);
        return (T)result;
    }

    public String getXML(String resource) throws IOException {
        if (this.mockResponse != null) {
            return this.mockResponse;
        }
        HttpResponse response = this.invokeGET(resource).execute();
        return response.parseAsString();
    }

    @Deprecated
    protected HttpRequest invokeGET(String resource) throws IOException {
        String urlToFetch = this.buildUrl(resource);
        LOG.debug("Hitting " + urlToFetch);
        return this.requestFactory.buildGetRequest(new GenericUrl(urlToFetch)).setConnectTimeout(this.socketTimeout).setReadTimeout(this.readTimeout);
    }

    protected HttpRequest invokeGET(String resource, int apiVersion) throws IOException {
        String urlToFetch = this.buildUrl(resource);
        LOG.debug("Hitting " + urlToFetch);
        HttpRequest httpRequest = this.requestFactory.buildGetRequest(new GenericUrl(urlToFetch));
        return httpRequest.setHeaders(httpRequest.getHeaders().setAccept("application/vnd.go.cd.v" + apiVersion + "+json")).setConnectTimeout(this.socketTimeout).setReadTimeout(this.readTimeout);
    }

    protected HttpRequest invokePATCH(String resource, int apiVersion, Object payload) throws IOException {
        String urlToFetch = this.buildUrl(resource);
        LOG.debug("Hitting " + urlToFetch);
        HttpRequest httpRequest = this.requestFactory.buildPatchRequest(new GenericUrl(urlToFetch), (HttpContent)new JsonHttpContent((JsonFactory)GsonFactory.getDefaultInstance(), payload));
        return httpRequest.setHeaders(httpRequest.getHeaders().setAccept("application/vnd.go.cd.v" + apiVersion + "+json")).setConnectTimeout(this.socketTimeout).setReadTimeout(this.readTimeout);
    }

    private String buildUrl(String resource) {
        try {
            return URI.create(String.format("%s/%s", this.serverHost, resource)).normalize().toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

