/*
 * Decompiled with CFR 0.152.
 */
package com.tw.go.plugin.jgit;

import com.tw.go.plugin.GitHelper;
import com.tw.go.plugin.cmd.InMemoryConsumer;
import com.tw.go.plugin.cmd.ProcessOutputStreamConsumer;
import com.tw.go.plugin.model.GitConfig;
import com.tw.go.plugin.model.ModifiedFile;
import com.tw.go.plugin.model.Revision;
import com.tw.go.plugin.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CleanCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.GarbageCollectCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.SubmoduleAddCommand;
import org.eclipse.jgit.api.SubmoduleStatusCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.submodule.SubmoduleStatus;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.io.DisabledOutputStream;

public class JGitHelper
extends GitHelper {
    public JGitHelper(GitConfig gitConfig, File workingDir) {
        this(gitConfig, workingDir, new ProcessOutputStreamConsumer(new InMemoryConsumer()), new ProcessOutputStreamConsumer(new InMemoryConsumer()));
    }

    public JGitHelper(GitConfig gitConfig, File workingDir, ProcessOutputStreamConsumer stdOut, ProcessOutputStreamConsumer stdErr) {
        super(gitConfig, workingDir, stdOut, stdErr);
    }

    @Override
    public String version() {
        return "3.6.2.201501210735-r";
    }

    @Override
    public void checkConnection() {
        try {
            LsRemoteCommand lsRemote = Git.lsRemoteRepository().setHeads(true).setRemote(this.gitConfig.getUrl());
            this.setCredentials((TransportCommand)lsRemote);
            lsRemote.call();
        }
        catch (Exception e) {
            throw new RuntimeException("check connection (ls-remote) failed", e);
        }
    }

    @Override
    public void cloneRepository() {
        CloneCommand clone = Git.cloneRepository().setURI(this.gitConfig.getUrl()).setBranch(this.gitConfig.getEffectiveBranch()).setDirectory(this.workingDir);
        if (this.gitConfig.isRecursiveSubModuleUpdate()) {
            clone.setCloneSubmodules(true);
        }
        this.setCredentials((TransportCommand)clone);
        try {
            clone.call();
        }
        catch (Exception e) {
            throw new RuntimeException("clone failed", e);
        }
    }

    @Override
    public void checkoutRemoteBranchToLocal() {
        try (Repository repository = null;){
            repository = this.getRepository(this.workingDir);
            Git git = new Git(repository);
            CheckoutCommand checkout = git.checkout().setForce(true).setName(this.gitConfig.getEffectiveBranch());
            checkout.call();
        }
    }

    @Override
    public String workingRepositoryUrl() {
        try (Repository repository = null;){
            repository = this.getRepository(this.workingDir);
            String string = repository.getConfig().getString("remote", "origin", "url");
            return string;
        }
    }

    @Override
    public String getCurrentBranch() {
        try (Repository repository = null;){
            repository = this.getRepository(this.workingDir);
            String string = repository.getBranch();
            return string;
        }
    }

    @Override
    public int getCommitCount() {
        int count = 0;
        try (Repository repository = null;){
            repository = this.getRepository(this.workingDir);
            Git git = new Git(repository);
            LogCommand logCmd = git.log();
            Iterable log = logCmd.call();
            for (RevCommit commit : log) {
                ++count;
            }
        }
        return count;
    }

    @Override
    public String currentRevision() {
        return this.getLatestRevision().getRevision();
    }

    @Override
    public List<Revision> getAllRevisions() {
        try (Repository repository = null;){
            repository = this.getRepository(this.workingDir);
            Git git = new Git(repository);
            LogCommand logCmd = git.log();
            Iterable log = logCmd.call();
            ArrayList<Revision> revisionObjs = new ArrayList<Revision>();
            for (RevCommit commit : log) {
                Revision revisionObj = this.getRevisionObj(repository, commit);
                revisionObjs.add(revisionObj);
            }
            ArrayList<Revision> arrayList = revisionObjs;
            return arrayList;
        }
    }

    @Override
    public Revision getLatestRevision() {
        try (Repository repository = null;){
            repository = this.getRepository(this.workingDir);
            Git git = new Git(repository);
            LogCommand logCmd = git.log().setMaxCount(1);
            Iterable log = logCmd.call();
            Iterator iterator = log.iterator();
            if (iterator.hasNext()) {
                Revision revision = this.getRevisionObj(repository, (RevCommit)iterator.next());
                return revision;
            }
        }
        return null;
    }

    @Override
    public List<Revision> getRevisionsSince(String previousRevision) {
        try (Repository repository = null;){
            RevCommit commit;
            repository = this.getRepository(this.workingDir);
            Git git = new Git(repository);
            LogCommand logCmd = git.log();
            Iterable log = logCmd.call();
            ArrayList<RevCommit> newCommits = new ArrayList<RevCommit>();
            Iterator i$ = log.iterator();
            while (i$.hasNext() && !(commit = (RevCommit)i$.next()).getName().equals(previousRevision)) {
                newCommits.add(commit);
            }
            ArrayList<Revision> revisionObjs = new ArrayList<Revision>();
            if (!newCommits.isEmpty()) {
                for (RevCommit newCommit : newCommits) {
                    Revision revisionObj = this.getRevisionObj(repository, newCommit);
                    revisionObjs.add(revisionObj);
                }
            }
            ArrayList<Revision> arrayList = revisionObjs;
            return arrayList;
        }
    }

    @Override
    public Revision getDetailsForRevision(String sha) {
        try (Repository repository = null;){
            repository = this.getRepository(this.workingDir);
            Git git = new Git(repository);
            LogCommand logCmd = git.log().all();
            Iterable log = logCmd.call();
            for (RevCommit commit : log) {
                if (!commit.getName().equals(sha)) continue;
                Revision revision = this.getRevisionObj(repository, commit);
                return revision;
            }
            Revision revision = null;
            return revision;
        }
    }

    @Override
    public Map<String, String> getBranchToRevisionMap(String pattern) {
        try (Repository repository = null;){
            repository = this.getRepository(this.workingDir);
            Map allRefs = repository.getAllRefs();
            HashMap<String, String> branchToRevisionMap = new HashMap<String, String>();
            for (String refName : allRefs.keySet()) {
                if (!refName.contains(pattern)) continue;
                String branch = refName.replace(pattern, "");
                String revision = ((Ref)allRefs.get(refName)).getObjectId().getName();
                branchToRevisionMap.put(branch, revision);
            }
            HashMap<String, String> hashMap = branchToRevisionMap;
            return hashMap;
        }
    }

    @Override
    public void pull() {
    }

    @Override
    public void fetch(String refSpec) {
        try (Repository repository = null;){
            repository = this.getRepository(this.workingDir);
            Git git = new Git(repository);
            FetchCommand fetch = git.fetch().setRemoveDeletedRefs(true);
            if (!StringUtil.isEmpty(refSpec)) {
                fetch.setRefSpecs(new RefSpec[]{new RefSpec(refSpec)});
            }
            this.setCredentials((TransportCommand)fetch);
            fetch.call();
        }
    }

    @Override
    public void resetHard(String revision) {
        try (Repository repository = null;){
            repository = this.getRepository(this.workingDir);
            Git git = new Git(repository);
            ResetCommand reset = git.reset().setMode(ResetCommand.ResetType.HARD).setRef(revision);
            reset.call();
        }
    }

    @Override
    public void cleanAllUnversionedFiles() {
        Repository repository = null;
        SubmoduleWalk walk = null;
        try {
            repository = this.getRepository(this.workingDir);
            Git git = new Git(repository);
            walk = SubmoduleWalk.forIndex((Repository)repository);
            if (walk != null) {
                while (walk.next()) {
                    this.cleanSubmoduleOfAllUnversionedFiles(walk);
                }
            }
            CleanCommand clean = git.clean().setCleanDirectories(true);
            clean.call();
        }
        catch (Exception e) {
            throw new RuntimeException("clean failed", e);
        }
        finally {
            if (walk != null) {
                walk.close();
            }
            if (repository != null) {
                repository.close();
            }
        }
    }

    private void cleanSubmoduleOfAllUnversionedFiles(SubmoduleWalk walk) {
        try (Repository submoduleRepository = null;){
            submoduleRepository = walk.getRepository();
            if (submoduleRepository != null) {
                CleanCommand clean = Git.wrap((Repository)submoduleRepository).clean().setCleanDirectories(true);
                clean.call();
            }
        }
    }

    @Override
    public void gc() {
        try (Repository repository = null;){
            repository = this.getRepository(this.workingDir);
            Git git = new Git(repository);
            GarbageCollectCommand gc = git.gc();
            gc.call();
        }
    }

    @Override
    public Map<String, String> submoduleUrls() {
        return null;
    }

    @Override
    public List<String> submoduleFolders() {
        try (Repository repository = null;){
            repository = this.getRepository(this.workingDir);
            Git git = new Git(repository);
            SubmoduleStatusCommand submoduleStatus = git.submoduleStatus();
            Map submoduleStatusMap = submoduleStatus.call();
            ArrayList<String> submoduleFolders = new ArrayList<String>();
            for (String submoduleFolder : submoduleStatusMap.keySet()) {
                submoduleFolders.add(submoduleFolder);
            }
            ArrayList<String> arrayList = submoduleFolders;
            return arrayList;
        }
    }

    @Override
    public void printSubmoduleStatus() {
        try (Repository repository = null;){
            repository = this.getRepository(this.workingDir);
            Git git = new Git(repository);
            SubmoduleStatusCommand submoduleStatus = git.submoduleStatus();
            Map submoduleStatusMap = submoduleStatus.call();
            for (String submoduleFolder : submoduleStatusMap.keySet()) {
                this.stdOut.consumeLine(submoduleFolder + " " + ((SubmoduleStatus)submoduleStatusMap.get(submoduleFolder)).getType());
            }
        }
    }

    @Override
    public void checkoutAllModifiedFilesInSubmodules() {
        Repository repository = null;
        SubmoduleWalk walk = null;
        try {
            repository = this.getRepository(this.workingDir);
            walk = SubmoduleWalk.forIndex((Repository)repository);
            while (walk.next()) {
                this.checkoutSubmodule(walk);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("checkout all sub-modules failed", e);
        }
        finally {
            if (walk != null) {
                walk.close();
            }
            if (repository != null) {
                repository.close();
            }
        }
    }

    private void checkoutSubmodule(SubmoduleWalk walk) {
        try (Repository submoduleRepository = null;){
            submoduleRepository = walk.getRepository();
            CheckoutCommand checkout = Git.wrap((Repository)submoduleRepository).checkout().setForce(true).setName("HEAD");
            checkout.call();
        }
    }

    @Override
    public int getSubModuleCommitCount(String subModuleFolder) {
        Repository repository = null;
        Repository subModuleRepository = null;
        int count = 0;
        try {
            repository = this.getRepository(this.workingDir);
            subModuleRepository = SubmoduleWalk.getSubmoduleRepository((Repository)repository, (String)subModuleFolder);
            Git git = new Git(subModuleRepository);
            Iterable log = git.log().call();
            for (RevCommit commit : log) {
                ++count;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("sub-module commit count failed", e);
        }
        finally {
            if (repository != null) {
                repository.close();
            }
            if (subModuleRepository != null) {
                subModuleRepository.close();
            }
        }
        return count;
    }

    @Override
    public void submoduleInit() {
        try (Repository repository = null;){
            repository = this.getRepository(this.workingDir);
            Git git = new Git(repository);
            git.submoduleInit().call();
        }
    }

    @Override
    public void submoduleSync() {
        try (Repository repository = null;){
            repository = this.getRepository(this.workingDir);
            Git git = new Git(repository);
            git.submoduleSync().call();
        }
    }

    @Override
    public void submoduleUpdate() {
        try (Repository repository = null;){
            repository = this.getRepository(this.workingDir);
            Git git = new Git(repository);
            git.submoduleUpdate().call();
        }
    }

    @Override
    public void init() {
        try (Repository repository = null;){
            Git.init().setDirectory(this.workingDir).call();
            repository = FileRepositoryBuilder.create((File)new File(this.workingDir.getAbsolutePath(), ".git"));
        }
    }

    @Override
    public void add(File fileToAdd) {
        try (Repository repository = null;){
            repository = this.getRepository(this.workingDir);
            Git git = new Git(repository);
            AddCommand add = git.add().addFilepattern(fileToAdd.getName());
            add.call();
        }
    }

    @Override
    public void commit(String message) {
        try (Repository repository = null;){
            repository = this.getRepository(this.workingDir);
            Git git = new Git(repository);
            CommitCommand commit = git.commit().setAuthor("author", "author@nodomain.com").setMessage(message);
            commit.call();
        }
    }

    @Override
    public void commitOnDate(String message, Date commitDate) {
    }

    @Override
    public void submoduleAdd(String subModuleFolder, String subModuleName, String relativePath) {
        Repository parentRepository = null;
        Repository subModuleRepository = null;
        try {
            parentRepository = this.getRepository(this.workingDir);
            subModuleRepository = this.getRepository(new File(subModuleFolder));
            Git git = new Git(parentRepository);
            SubmoduleAddCommand subModuleAdd = git.submoduleAdd().setURI(subModuleRepository.getDirectory().getCanonicalPath()).setPath(relativePath);
            subModuleAdd.call();
        }
        catch (Exception e) {
            throw new RuntimeException("add sub-module failed", e);
        }
        finally {
            if (parentRepository != null) {
                parentRepository.close();
            }
            if (subModuleRepository != null) {
                subModuleRepository.close();
            }
        }
    }

    @Override
    public void removeSubmoduleSectionsFromGitConfig() {
        List<String> submoduleFolders = this.submoduleFolders();
        for (String submoduleFolder : submoduleFolders) {
            this.configRemoveSection(submoduleFolder);
        }
    }

    @Override
    public void submoduleRemove(String folderName) {
        this.configRemoveSection(folderName);
        try (Repository repository = null;){
            repository = this.getRepository(this.workingDir);
            FileBasedConfig gitSubmodulesConfig = new FileBasedConfig(null, new File(repository.getWorkTree(), ".gitmodules"), FS.DETECTED);
            gitSubmodulesConfig.unsetSection("submodule", folderName);
            gitSubmodulesConfig.save();
            Git git = Git.wrap((Repository)repository);
            git.rm().setCached(true).addFilepattern(folderName).call();
            FileUtils.deleteQuietly((File)new File(this.workingDir, folderName));
        }
    }

    private void configRemoveSection(String folderName) {
        try (Repository repository = null;){
            repository = this.getRepository(this.workingDir);
            StoredConfig repositoryConfig = repository.getConfig();
            repositoryConfig.unsetSection("submodule", folderName);
            repositoryConfig.save();
        }
    }

    @Override
    public void changeSubmoduleUrl(String submoduleName, String newUrl) {
    }

    @Override
    public void push() {
    }

    private Revision getRevisionObj(Repository repository, RevCommit commit) throws IOException {
        String commitSHA = commit.getName();
        Date commitTime = commit.getAuthorIdent().getWhen();
        String comment = commit.getFullMessage().trim();
        String user = commit.getAuthorIdent().getName();
        String emailId = commit.getAuthorIdent().getEmailAddress();
        ArrayList<ModifiedFile> modifiedFiles = new ArrayList<ModifiedFile>();
        if (commit.getParentCount() == 0) {
            TreeWalk treeWalk = new TreeWalk(repository);
            treeWalk.addTree((AnyObjectId)commit.getTree());
            treeWalk.setRecursive(false);
            while (treeWalk.next()) {
                modifiedFiles.add(new ModifiedFile(treeWalk.getPathString(), "added"));
            }
        } else {
            RevWalk rw = new RevWalk(repository);
            RevCommit parent = rw.parseCommit((AnyObjectId)commit.getParent(0).getId());
            DiffFormatter diffFormatter = new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE);
            diffFormatter.setRepository(repository);
            diffFormatter.setDiffComparator(RawTextComparator.DEFAULT);
            diffFormatter.setDetectRenames(true);
            List diffEntries = diffFormatter.scan(parent.getTree(), commit.getTree());
            for (DiffEntry diffEntry : diffEntries) {
                modifiedFiles.add(new ModifiedFile(diffEntry.getNewPath(), this.getAction(diffEntry.getChangeType().name())));
            }
        }
        return new Revision(commitSHA, commitTime, comment, user, emailId, modifiedFiles);
    }

    private String getAction(String gitAction) {
        if (gitAction.equalsIgnoreCase("ADD") || gitAction.equalsIgnoreCase("RENAME")) {
            return "added";
        }
        if (gitAction.equals("MODIFY")) {
            return "modified";
        }
        if (gitAction.equals("DELETE")) {
            return "deleted";
        }
        return "unknown";
    }

    private Repository getRepository(File folder) throws IOException {
        return ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(this.getGitDir(folder))).readEnvironment()).findGitDir()).build();
    }

    private File getGitDir(File folder) {
        return new File(folder, ".git");
    }

    private void setCredentials(TransportCommand command) {
        if (this.gitConfig.isRemoteUrl() && this.gitConfig.hasCredentials()) {
            command.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.gitConfig.getUsername(), this.gitConfig.getPassword()));
        }
    }
}

