/*
 * Decompiled with CFR 0.152.
 */
package in.ankushs.dbip.repository;

import com.google.common.net.InetAddresses;
import in.ankushs.dbip.api.GeoEntity;
import in.ankushs.dbip.model.GeoAttributes;
import in.ankushs.dbip.repository.DbIpRepository;
import in.ankushs.dbip.utils.IPUtils;
import in.ankushs.dbip.utils.PreConditions;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaMapDbIpRepositoryImpl
implements DbIpRepository {
    private static final Logger logger = LoggerFactory.getLogger(JavaMapDbIpRepositoryImpl.class);
    private static JavaMapDbIpRepositoryImpl instance = null;
    private static final TreeMap<Integer, GeoEntity> IPV4_REPOSITORY = new TreeMap();
    private static final TreeMap<BigInteger, GeoEntity> IPV6_REPOSITORY = new TreeMap();

    private JavaMapDbIpRepositoryImpl() {
    }

    public static JavaMapDbIpRepositoryImpl getInstance() {
        if (instance == null) {
            return new JavaMapDbIpRepositoryImpl();
        }
        return instance;
    }

    @Override
    public GeoEntity get(InetAddress inetAddress) {
        PreConditions.checkNull(inetAddress, "inetAddress must not be null");
        Object result = null;
        if (inetAddress instanceof Inet4Address) {
            Integer startIpNum = InetAddresses.coerceToInteger((InetAddress)inetAddress);
            return IPV4_REPOSITORY.floorEntry(startIpNum) == null ? null : IPV4_REPOSITORY.floorEntry(startIpNum).getValue();
        }
        BigInteger startIpBigInt = IPUtils.ipv6ToBigInteger(inetAddress);
        return IPV6_REPOSITORY.floorEntry(startIpBigInt) == null ? null : IPV6_REPOSITORY.floorEntry(startIpBigInt).getValue();
    }

    @Override
    public void save(GeoAttributes geoAttributes) {
        PreConditions.checkNull(geoAttributes, "geoAttributes must not be null");
        InetAddress startInetAddress = geoAttributes.getStartInetAddress();
        InetAddress endInetAddress = geoAttributes.getEndInetAddress();
        GeoEntity geoEntity = geoAttributes.getGeoEntity();
        if (startInetAddress instanceof Inet6Address && endInetAddress instanceof Inet6Address) {
            BigInteger startIpBigInt = IPUtils.ipv6ToBigInteger(startInetAddress);
            IPV6_REPOSITORY.put(startIpBigInt, geoEntity);
        } else if (startInetAddress instanceof Inet4Address && endInetAddress instanceof Inet4Address) {
            Integer startIpNum = InetAddresses.coerceToInteger((InetAddress)startInetAddress);
            IPV4_REPOSITORY.put(startIpNum, geoEntity);
        } else {
            logger.warn("This shouldn't ever happen");
        }
    }

    public static TreeMap<Integer, GeoEntity> getIpv4Repository() {
        return IPV4_REPOSITORY;
    }
}

