package in.ankushs.dbip.api;

/**
 * 
 *
 * @author Ankush Sharma
 */
public final class GeoEntity {

	private final String city;
	private final String country;
	private final String province;
	private final String countryCode;
	private final String isp;
	private final String district;
	private final String zipCode;
	private final Double lat;
	private final Double lng;
	private final String timezone;
	private final String connectionType;
	private final String org;

	public GeoEntity(final Builder builder){
		this.city = builder.city;
		this.country = builder.country;
		this.province = builder.province;
		this.countryCode = builder.countryCode;
		this.isp = builder.isp;
		this.district = builder.district;
		this.zipCode = builder.zipCode;
		this.lat = builder.lat;
		this.lng = builder.lng;
		this.timezone = builder.timezone;
		this.connectionType = builder.connectionType;
		this.org = builder.org;
	}
	 
	public static class Builder{
		private String countryCode;
		private String city;
		private String country;
		private String province;
		private String isp;
		private  String district;
		private  String zipCode;
		private  Double lat;
		private  Double lng;
		private  String timezone;
		private  String connectionType;
		private  String org;

		public Builder withDistrict(final String district){
			this.district = district;
			return this;
		}

		public Builder withConnType(final String connType){
			this.connectionType = connType;
			return this;
		}


		public Builder withZipCode(final String zipCode){
			this.zipCode = zipCode;
			return this;
		}


		public Builder withLat(final Double lat){
			this.lat = lat;
			return this;
		}

		public Builder withLng(final Double lng){
			this.lng = lng;
			return this;
		}

		public Builder withTimezone(final String timezone){
			this.timezone = timezone;
			return this;
		}

		public Builder withOrg(final String org){
			this.org = org;
			return this;
		}

		public Builder withIsp(final String isp){
			this.isp = isp;
			return this;
		}

		public Builder withCountryCode(final String countryCode){
			this.countryCode = countryCode;
			return this;
		}
		
		public Builder withCity(final String city ){
			this.city = city;
			return this;
		}
		
		public Builder withCountry(final String country ){
			this.country = country;
			return this;
		}
		
		public Builder withProvince(final String province ){
			this.province = province;
			return this;
		}
		
		public GeoEntity build(){
			return new GeoEntity(this);
		}
	}

	public String getCity() {
		return city;
	}

	public String getCountry() {
		return country;
	}

	public String getProvince() {
		return province;
	}

	public String getDistrict() {
		return district;
	}

	public String getZipCode() {
		return zipCode;
	}

	public Double getLat() {
		return lat;
	}

	public Double getLng() {
		return lng;
	}

	public String getTimezone() {
		return timezone;
	}

	public String getConnectionType() {
		return connectionType;
	}

	public String getOrg() {
		return org;
	}

	@Override
	public String toString() {
		return "GeoEntity{" +
				"city='" + city + '\'' +
				", country='" + country + '\'' +
				", province='" + province + '\'' +
				", countryCode='" + countryCode + '\'' +
				", isp='" + isp + '\'' +
				", district='" + district + '\'' +
				", zipCode='" + zipCode + '\'' +
				", lat=" + lat +
				", lng=" + lng +
				", timezone='" + timezone + '\'' +
				", connectionType='" + connectionType + '\'' +
				", org='" + org + '\'' +
				'}';
	}

	public String getCountryCode() {
		return countryCode;
	}

	public String getIsp() {
		return isp;
	}
}
