/*
 * Decompiled with CFR 0.152.
 */
package in.ankushs.dbip.importer;

import com.google.common.net.InetAddresses;
import in.ankushs.dbip.model.GeoAttributesImpl;
import in.ankushs.dbip.parser.CsvParser;
import in.ankushs.dbip.parser.CsvParserImpl;
import in.ankushs.dbip.repository.DbIpRepository;
import in.ankushs.dbip.repository.JavaMapDbIpRepositoryImpl;
import in.ankushs.dbip.utils.CountryResolver;
import in.ankushs.dbip.utils.GzipUtils;
import in.ankushs.dbip.utils.PreConditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceImporter {
    private static final Logger logger = LoggerFactory.getLogger(ResourceImporter.class);
    private final DbIpRepository repository = JavaMapDbIpRepositoryImpl.getInstance();
    private final CsvParser csvParser = CsvParserImpl.getInstance();
    private static ResourceImporter instance = null;

    private ResourceImporter() {
    }

    public static ResourceImporter getInstance() {
        if (instance == null) {
            return new ResourceImporter();
        }
        return instance;
    }

    public void load(File file) {
        try {
            PreConditions.checkExpression(!GzipUtils.isGzipped(file), "Not a  gzip file");
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
        }
        try (FileInputStream fis = new FileInputStream(file);
             GZIPInputStream gis = new GZIPInputStream(fis);
             InputStreamReader decorator = new InputStreamReader((InputStream)gis, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(decorator);){
            logger.debug("Reading dbip data from {}", (Object)file.getName());
            String line = null;
            int i = 0;
            while ((line = reader.readLine()) != null) {
                String[] array = this.csvParser.parseRecord(line);
                GeoAttributesImpl geoAttributes = new GeoAttributesImpl.Builder().withCity(array[4]).withCountry(CountryResolver.resolveToFullName(array[2])).withProvince(array[3]).withEndIp(InetAddresses.forString((String)array[1])).withStartIp(InetAddresses.forString((String)array[0])).build();
                this.repository.save(geoAttributes);
                if (++i % 100000 != 0) continue;
                logger.debug("Loaded {} entries", (Object)i);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

