/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.jpegdecoder;

import de.matthiasmann.jpegdecoder.YUVDecoder;
import java.nio.ByteBuffer;

public class YUVtoRGBA
implements YUVDecoder {
    public static final YUVtoRGBA instance = new YUVtoRGBA();

    @Override
    public void decode(ByteBuffer out, int outPos, byte[] inY, byte[] inU, byte[] inV, int inPos, int count) {
        do {
            int y = inY[inPos] & 0xFF;
            int u = (inU[inPos] & 0xFF) - 128;
            int v = (inV[inPos] & 0xFF) - 128;
            int r = y + (32768 + v * 91881 >> 16);
            int g = y + (32768 - v * 46802 - u * 22554 >> 16);
            int b = y + (32768 + u * 116130 >> 16);
            if (r > 255) {
                r = 255;
            } else if (r < 0) {
                r = 0;
            }
            if (g > 255) {
                g = 255;
            } else if (g < 0) {
                g = 0;
            }
            if (b > 255) {
                b = 255;
            } else if (b < 0) {
                b = 0;
            }
            out.put(outPos + 0, (byte)r);
            out.put(outPos + 1, (byte)g);
            out.put(outPos + 2, (byte)b);
            out.put(outPos + 3, (byte)-1);
            outPos += 4;
            ++inPos;
        } while (--count > 0);
    }
}

