/*
 * Decompiled with CFR 0.152.
 */
package guru.timeseries.client;

import de.taimos.httputils.HTTPRequest;
import de.taimos.httputils.WS;
import guru.timeseries.client.AClient;
import guru.timeseries.client.ISyncClient;
import org.apache.http.HttpResponse;

final class SyncClient
extends AClient
implements ISyncClient {
    private final String databaseID;
    private final int timeout;
    private final String apiBase;
    private final String auth;

    public SyncClient(String apiBase, String token, String databaseID, int timeout) {
        this.databaseID = databaseID;
        this.timeout = timeout;
        this.apiBase = apiBase;
        this.auth = "Token " + token;
    }

    private void send(String timeseriesName, String symbol, String csv) throws Exception {
        HTTPRequest req = symbol != null ? WS.url((String)(this.apiBase + "/databases/{databaseID}/timeseries/{timeseriesName}/{symbol}/data")).pathParam("symbol", symbol) : WS.url((String)(this.apiBase + "/databases/{databaseID}/timeseries/{timeseriesName}/data"));
        HttpResponse res = req.pathParam("databaseID", this.databaseID).pathParam("timeseriesName", timeseriesName).auth(this.auth).timeout(this.timeout).body(csv).contentType("text/csv").post();
        int status = WS.getStatus((HttpResponse)res);
        if (status != 204) {
            throw new Exception("unexpected status code " + status + ": " + WS.getResponseAsString((HttpResponse)res));
        }
    }

    @Override
    public void insert(String timeseriesName, Object ... values) throws Exception {
        this.send(timeseriesName, null, SyncClient.join(values));
    }

    @Override
    public void insertSymbol(String timeseriesName, String symbol, Object ... values) throws Exception {
        this.send(timeseriesName, symbol, SyncClient.join(values));
    }

    @Override
    public ISyncClient.ISyncBulkInsert bulk() {
        return new ISyncClient.ISyncBulkInsert(){
            private final StringBuilder body = new StringBuilder();

            @Override
            public ISyncClient.ISyncBulkInsert add(String timeseriesName, Object ... values) {
                this.body.append(timeseriesName);
                this.body.append(",");
                this.body.append(AClient.join(values));
                this.body.append("\n");
                return this;
            }

            @Override
            public ISyncClient.ISyncBulkInsert addSymbol(String timeseriesName, String symbol, Object ... values) {
                this.body.append(timeseriesName);
                this.body.append(",");
                this.body.append(symbol);
                this.body.append(",");
                this.body.append(AClient.join(values));
                this.body.append("\n");
                return this;
            }

            @Override
            public void insert() throws Exception {
                if (this.body.length() == 0) {
                    return;
                }
                HttpResponse res = WS.url((String)(SyncClient.this.apiBase + "/databases/{databaseID}/data")).pathParam("databaseID", SyncClient.this.databaseID).auth(SyncClient.this.auth).timeout(SyncClient.this.timeout).body(this.body.toString()).contentType("text/csv").post();
                int status = WS.getStatus((HttpResponse)res);
                if (status != 204) {
                    throw new Exception("unexpected status code " + status);
                }
            }
        };
    }
}

