/*
 * Decompiled with CFR 0.152.
 */
package guru.timeseries.client;

import com.google.gson.Gson;
import de.taimos.httputils.WS;
import guru.timeseries.client.Area;
import guru.timeseries.client.AsyncClient;
import guru.timeseries.client.IAsyncClient;
import guru.timeseries.client.ISyncClient;
import guru.timeseries.client.SyncClient;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.http.HttpResponse;

public final class ClientFactory {
    static final int DEFAULT_TIMEOUT = 10000;

    private static String getRegion(String apiBase, String token, String databaseID, int timeout) throws Exception {
        HttpResponse res = WS.url((String)(apiBase + "/databases/{databaseID}")).pathParam("databaseID", databaseID).auth("Token " + token).timeout(timeout).accept("application/json").get();
        int status = WS.getStatus((HttpResponse)res);
        if (status == 404) {
            throw new Exception("database not found");
        }
        if (status == 200) {
            String body = WS.getResponseAsString((HttpResponse)res);
            Map map = (Map)new Gson().fromJson(body, HashMap.class);
            return (String)map.get("region");
        }
        throw new Exception("unexpected status code " + status);
    }

    private static String getApiBase(Area area) {
        return "https://" + area.name() + "-" + "api.timeseries.guru";
    }

    private static String getApiBaseRegion(Area area, String region) {
        return "https://" + area.name() + "-" + region + "-api.timeseries.guru";
    }

    static ISyncClient connectSync(Area area, String token, String databaseID, int timeout) throws Exception {
        String apiBase = ClientFactory.getApiBase(area);
        String region = ClientFactory.getRegion(apiBase, token, databaseID, timeout);
        return new SyncClient(ClientFactory.getApiBaseRegion(area, region), token, databaseID, timeout);
    }

    static ISyncClient connectSync(String apiBase, String token, String databaseID, int timeout) throws Exception {
        return new SyncClient(apiBase, token, databaseID, timeout);
    }

    static IAsyncClient connectAsync(Executor executor, Area area, String token, String databaseID, int timeout) throws Exception {
        String apiBase = ClientFactory.getApiBase(area);
        String region = ClientFactory.getRegion(apiBase, token, databaseID, timeout);
        return new AsyncClient(executor, ClientFactory.getApiBaseRegion(area, region), token, databaseID, timeout);
    }

    static IAsyncClient connectAsync(Executor executor, String apiBase, String token, String databaseID, int timeout) throws Exception {
        return new AsyncClient(executor, apiBase, token, databaseID, timeout);
    }

    public static ISyncClient connectSync(String token, String databaseID) throws Exception {
        return ClientFactory.connectSync(token, databaseID, 10000);
    }

    public static ISyncClient connectSync(String token, String databaseID, int timeout) throws Exception {
        return ClientFactory.connectSync(Area.production, token, databaseID, timeout);
    }

    public static IAsyncClient connectAsync(Executor executor, String token, String databaseID, int timeout) throws Exception {
        return ClientFactory.connectAsync(executor, Area.production, token, databaseID, timeout);
    }

    public static IAsyncClient connectAsync(Executor executor, String token, String databaseID) throws Exception {
        return ClientFactory.connectAsync(executor, token, databaseID, 10000);
    }

    public static IAsyncClient connectAsync(String token, String databaseID) throws Exception {
        ExecutorService executor = Executors.newCachedThreadPool();
        return ClientFactory.connectAsync(executor, token, databaseID, 10000);
    }

    private ClientFactory() {
    }
}

