/*
 * Decompiled with CFR 0.152.
 */
package guru.timeseries.client;

import com.google.common.util.concurrent.SettableFuture;
import de.taimos.httputils.HTTPRequest;
import de.taimos.httputils.WS;
import guru.timeseries.client.AClient;
import guru.timeseries.client.IAsyncClient;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.apache.http.HttpResponse;

final class AsyncClient
extends AClient
implements IAsyncClient {
    private final Executor executor;
    private final String databaseID;
    private final int timeout;
    private final String apiBase;
    private final String auth;

    public AsyncClient(Executor executor, String apiBase, String token, String databaseID, int timeout) {
        this.executor = executor;
        this.databaseID = databaseID;
        this.timeout = timeout;
        this.apiBase = apiBase;
        this.auth = "Token " + token;
    }

    private Future<Void> send(final String timeseriesName, final String symbol, final String csv) {
        final SettableFuture future = SettableFuture.create();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    HTTPRequest req = symbol != null ? WS.url((String)(AsyncClient.this.apiBase + "/databases/{databaseID}/timeseries/{timeseriesName}/{symbol}/data")).pathParam("symbol", symbol) : WS.url((String)(AsyncClient.this.apiBase + "/databases/{databaseID}/timeseries/{timeseriesName}/data"));
                    HttpResponse res = req.pathParam("databaseID", AsyncClient.this.databaseID).pathParam("timeseriesName", timeseriesName).auth(AsyncClient.this.auth).timeout(AsyncClient.this.timeout).body(csv).contentType("text/csv").post();
                    int status = WS.getStatus((HttpResponse)res);
                    if (status != 204) {
                        throw new Exception("unexpected status code " + status + ": " + WS.getResponseAsString((HttpResponse)res));
                    }
                    future.set(null);
                }
                catch (Exception e) {
                    future.setException((Throwable)e);
                }
            }
        });
        return future;
    }

    @Override
    public Future<Void> insert(String timeseriesName, Object ... values) {
        return this.send(timeseriesName, null, AsyncClient.join(values));
    }

    @Override
    public Future<Void> insertSymbol(String timeseriesName, String symbol, Object ... values) {
        return this.send(timeseriesName, symbol, AsyncClient.join(values));
    }

    @Override
    public IAsyncClient.IAsyncBulkInsert bulk() {
        return new IAsyncClient.IAsyncBulkInsert(){
            private final StringBuilder body = new StringBuilder();

            @Override
            public IAsyncClient.IAsyncBulkInsert add(String timeseriesName, Object ... values) {
                this.body.append(timeseriesName);
                this.body.append(",");
                this.body.append(AClient.join(values));
                this.body.append("\n");
                return this;
            }

            @Override
            public IAsyncClient.IAsyncBulkInsert addSymbol(String timeseriesName, String symbol, Object ... values) {
                this.body.append(timeseriesName);
                this.body.append(",");
                this.body.append(symbol);
                this.body.append(",");
                this.body.append(AClient.join(values));
                this.body.append("\n");
                return this;
            }

            @Override
            public Future<Void> insert() {
                final SettableFuture future = SettableFuture.create();
                final String body = this.body.toString();
                if (body.length() == 0) {
                    future.set(null);
                    return future;
                }
                AsyncClient.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HttpResponse res = WS.url((String)(AsyncClient.this.apiBase + "/databases/{databaseID}/data")).pathParam("databaseID", AsyncClient.this.databaseID).auth(AsyncClient.this.auth).timeout(AsyncClient.this.timeout).body(body).contentType("text/csv").post();
                            int status = WS.getStatus((HttpResponse)res);
                            if (status != 204) {
                                throw new Exception("unexpected status code " + status);
                            }
                            future.set(null);
                        }
                        catch (Exception e) {
                            future.setException((Throwable)e);
                        }
                    }
                });
                return future;
            }
        };
    }
}

