/*
 * Decompiled with CFR 0.152.
 */
package guru.timeseries.client;

import de.taimos.httputils.WS;
import guru.timeseries.client.AClient;
import guru.timeseries.client.ISyncClient;
import org.apache.http.HttpResponse;

final class SyncClient
extends AClient
implements ISyncClient {
    private final String token;
    private final String databaseID;
    private final int timeout;
    private final String apiBase;
    private final String auth;

    public SyncClient(String apiBase, String token, String databaseID, int timeout) {
        this.token = token;
        this.databaseID = databaseID;
        this.timeout = timeout;
        this.apiBase = apiBase;
        this.auth = "Token " + this.token;
    }

    private void send(String timeseriesName, String csv) throws Exception {
        HttpResponse res = WS.url((String)(this.apiBase + "/databases/{databaseID}/timeseries/{timeseriesName}/data")).pathParam("databaseID", this.databaseID).pathParam("timeseriesName", timeseriesName).auth(this.auth).timeout(this.timeout).body(csv).contentType("text/csv").post();
        int status = WS.getStatus((HttpResponse)res);
        if (status != 204) {
            throw new Exception("unexpected status code " + status);
        }
    }

    @Override
    public void insert(String timeseriesName, float value) throws Exception {
        this.send(timeseriesName, Float.toString(value));
    }

    @Override
    public void insert(String timeseriesName, String symbol, float value) throws Exception {
        this.send(timeseriesName, symbol + "," + Float.toString(value));
    }

    @Override
    public ISyncClient.ISyncBulkInsert bulk() {
        return new ISyncClient.ISyncBulkInsert(){
            private final StringBuilder body = new StringBuilder();

            @Override
            public ISyncClient.ISyncBulkInsert add(String timeseriesName, float value) {
                this.body.append(timeseriesName);
                this.body.append(",");
                this.body.append(Float.toString(value));
                this.body.append("\n");
                return this;
            }

            @Override
            public ISyncClient.ISyncBulkInsert add(String timeseriesName, String symbol, float value) {
                this.body.append(timeseriesName);
                this.body.append(",");
                this.body.append(symbol);
                this.body.append(",");
                this.body.append(Float.toString(value));
                this.body.append("\n");
                return this;
            }

            @Override
            public void insert() throws Exception {
                if (this.body.length() == 0) {
                    return;
                }
                HttpResponse res = WS.url((String)(SyncClient.this.apiBase + "/databases/{databaseID}/data")).pathParam("databaseID", SyncClient.this.databaseID).auth(SyncClient.this.auth).timeout(SyncClient.this.timeout).body(this.body.toString()).contentType("text/csv").post();
                int status = WS.getStatus((HttpResponse)res);
                if (status != 204) {
                    throw new Exception("unexpected status code " + status);
                }
            }
        };
    }
}

