/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.service;

import guru.nidi.graphviz.service.DefaultExecutor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.exec.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandRunner {
    private static final Logger LOG = LoggerFactory.getLogger(CommandRunner.class);
    private final Function<CommandLine, CommandLine> wrapperFunc;
    private final DefaultExecutor cmdExec;

    CommandRunner(Function<CommandLine, CommandLine> wrapperFunc, DefaultExecutor cmdExec) {
        this.wrapperFunc = wrapperFunc;
        this.cmdExec = cmdExec;
    }

    void exec(CommandLine cmd, File workDir) throws IOException, InterruptedException {
        CommandLine wrappedCmd = this.wrapperFunc.apply(cmd);
        this.cmdExec.execute(wrappedCmd, workDir);
    }

    public void exec(String cmd, File workDir, String ... args) throws IOException, InterruptedException {
        this.exec(cmd, workDir, args, true);
    }

    private void exec(String cmd, File workDir, String[] args, boolean quote) throws IOException, InterruptedException {
        this.exec(new CommandLine(cmd).addArguments(args, quote), workDir);
    }

    private void exec(String cmd, File workDir, List<String> args) throws IOException, InterruptedException {
        this.exec(cmd, workDir, args.toArray(new String[args.size()]));
    }

    void exec(String cmd, List<String> args) throws IOException, InterruptedException {
        this.exec(cmd, null, args);
    }

    void exec(String cmd) throws IOException, InterruptedException {
        this.exec(cmd, null, new String[0]);
    }

    static Stream<Path> which(String program) {
        return CommandRunner.which(program, Optional.ofNullable(System.getenv("PATH")).orElse(""));
    }

    private static Stream<Path> which(String program, String pathEnvVar) {
        if (program == null || "".equals(program.trim()) || pathEnvVar == null || "".equalsIgnoreCase(pathEnvVar)) {
            return Stream.empty();
        }
        return Arrays.stream(pathEnvVar.split(File.pathSeparator)).map(path -> Paths.get(path, new String[0])).filter(path -> Files.exists(path, new LinkOption[0])).map(path -> {
            try (Stream<Path> entries = Files.list(path);){
                Stream stream = entries.filter(filePath -> program.equals(filePath.getFileName().toString())).filter(filePath -> Files.isRegularFile(filePath, new LinkOption[0])).filter(Files::isExecutable).collect(Collectors.toList()).stream();
                return stream;
            }
            catch (IOException e) {
                LOG.error("Problem finding path for {}", (Object)program, (Object)e);
                return Stream.empty();
            }
        }).flatMap(stream -> stream);
    }

    static boolean isExecutableFound(String program) {
        return CommandRunner.which(program).anyMatch(path -> true);
    }

    public static boolean isExecutableFound(String program, String envPath) {
        return CommandRunner.which(program, envPath).anyMatch(path -> true);
    }
}

