/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.AbstractGraphvizEngine;
import guru.nidi.graphviz.engine.IoUtils;
import guru.nidi.graphviz.engine.Options;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractJsGraphvizEngine
extends AbstractGraphvizEngine {
    public AbstractJsGraphvizEngine(boolean sync) {
        super(sync);
    }

    @Override
    public String execute(String src, Options options) {
        return this.jsExecute(this.jsVizExec(src, options));
    }

    protected abstract String jsExecute(String var1);

    protected String jsVizExec(String src, Options options) {
        return src.startsWith("Viz(") ? src : "Viz('" + this.jsEscape(src) + "'," + options.toJson(false) + ");";
    }

    protected String jsEscape(String js) {
        return js.replaceAll("\\R", " ").replace("\\", "\\\\").replace("'", "\\'");
    }

    protected String jsVizCode(String version) throws IOException {
        try (InputStream in = this.getClass().getResourceAsStream("/viz-" + version + ".js");){
            String string = IoUtils.readStream(in);
            return string;
        }
    }

    protected String jsInitEnv() {
        return "var $$prints=[], print=function(s){$$prints.push(s);};";
    }
}

