/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SystemUtils.class);
    private static final String OS_NAME = SystemUtils.getSystemProperty("os.name");
    public static final boolean IS_OS_WINDOWS = SystemUtils.getOsMatchesName("Windows");
    public static final boolean IS_OS_MAC = SystemUtils.getOsMatchesName("Mac");
    public static final boolean IS_OS_LINUX = SystemUtils.getOsMatchesName("Linux") || SystemUtils.getOsMatchesName("LINUX");

    private static String getSystemProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException e) {
            LOG.error("Caught a SecurityException reading the system property '{}'.The SystemUtils property value will default to null.", (Object)property);
            return null;
        }
    }

    private static boolean getOsMatchesName(String osNamePrefix) {
        return SystemUtils.isOsNameMatch(OS_NAME, osNamePrefix);
    }

    private static boolean isOsNameMatch(String osName, String osNamePrefix) {
        return osName != null && osName.startsWith(osNamePrefix);
    }
}

