/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.MutableAttributed;
import guru.nidi.graphviz.model.Label;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.Linkable;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import guru.nidi.graphviz.model.MutableNodePoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Serializer {
    private final MutableGraph graph;
    private final StringBuilder str;

    public Serializer(MutableGraph graph) {
        this.graph = graph;
        this.str = new StringBuilder();
    }

    public String serialize() {
        this.graph(this.graph, true);
        return this.str.toString();
    }

    private void graph(MutableGraph graph, boolean toplevel) {
        this.graphInit(graph, toplevel);
        this.graphAttrs(graph);
        ArrayList<MutableNode> nodes = new ArrayList<MutableNode>();
        ArrayList<MutableGraph> graphs = new ArrayList<MutableGraph>();
        Collection<Linkable> linkables = this.linkedNodes(graph.nodes);
        linkables.addAll(this.linkedNodes(graph.subgraphs));
        for (Linkable linkable : linkables) {
            if (linkable instanceof MutableNode) {
                MutableNode node = (MutableNode)linkable;
                int i = this.indexOfLabel(nodes, node.label);
                if (i < 0) {
                    nodes.add(node);
                    continue;
                }
                nodes.set(i, node.copy().merge((MutableNode)nodes.get(i)));
                continue;
            }
            graphs.add((MutableGraph)linkable);
        }
        this.nodes(graph, nodes);
        this.graphs(graphs, nodes);
        this.edges(nodes);
        this.edges(graphs);
        this.str.append('}');
    }

    private void graphAttrs(MutableGraph graph) {
        this.attributes("graph", graph.graphAttrs);
        this.attributes("node", graph.nodeAttrs);
        this.attributes("edge", graph.linkAttrs);
        for (Map.Entry entry : graph.generalAttrs) {
            this.attr((String)entry.getKey(), entry.getValue());
            this.str.append('\n');
        }
    }

    private void graphInit(MutableGraph graph, boolean toplevel) {
        if (toplevel) {
            this.str.append(graph.strict ? "strict " : "").append(graph.directed ? "digraph " : "graph ");
            if (!graph.label.isEmptyLabel()) {
                this.str.append(graph.label.serialized()).append(' ');
            }
        } else if (!graph.label.isEmptyLabel() || graph.cluster) {
            this.str.append("subgraph ").append((graph.cluster ? Label.of("cluster" + graph.label.value) : graph.label).serialized()).append(' ');
        }
        this.str.append("{\n");
    }

    private int indexOfLabel(List<MutableNode> nodes, Label label) {
        for (int i = 0; i < nodes.size(); ++i) {
            if (!nodes.get((int)i).label.equals(label)) continue;
            return i;
        }
        return -1;
    }

    private void attributes(String name, MutableAttributed<?> attributed) {
        if (!attributed.isEmpty()) {
            this.str.append(name);
            this.attrs(attributed);
            this.str.append('\n');
        }
    }

    private Collection<Linkable> linkedNodes(Collection<? extends Linkable> nodes) {
        LinkedHashSet<Linkable> visited = new LinkedHashSet<Linkable>();
        for (Linkable linkable : nodes) {
            this.linkedNodes(linkable, visited);
        }
        return visited;
    }

    private void linkedNodes(Linkable linkable, Set<Linkable> visited) {
        if (!visited.contains(linkable)) {
            visited.add(linkable);
            for (Link link : linkable.links()) {
                if (link.to instanceof MutableNodePoint) {
                    this.linkedNodes(((MutableNodePoint)link.to).node, visited);
                    continue;
                }
                if (link.to instanceof MutableGraph) {
                    this.linkedNodes((MutableGraph)link.to, visited);
                    continue;
                }
                throw new IllegalStateException("unexpected link to " + link.to);
            }
        }
    }

    private void nodes(MutableGraph graph, List<MutableNode> nodes) {
        for (MutableNode node : nodes) {
            if (node.attributes.isEmpty() && (!graph.nodes.contains(node) || !node.links.isEmpty())) continue;
            this.node(node);
            this.str.append('\n');
        }
    }

    private void graphs(List<MutableGraph> graphs, List<MutableNode> nodes) {
        for (MutableGraph graph : graphs) {
            if (!graph.links.isEmpty() || this.isLinked(graph, nodes) || this.isLinked(graph, graphs)) continue;
            this.graph(graph, false);
            this.str.append('\n');
        }
    }

    private boolean isLinked(MutableGraph graph, List<? extends Linkable> linkables) {
        for (Linkable linkable : linkables) {
            for (Link link : linkable.links()) {
                if (!link.to.equals(graph)) continue;
                return true;
            }
        }
        return false;
    }

    private void edges(List<? extends Linkable> linkables) {
        for (Linkable linkable : linkables) {
            for (Link link : linkable.links()) {
                this.linkTarget(link.from);
                this.str.append(this.graph.directed ? " -> " : " -- ");
                this.linkTarget(link.to);
                this.attrs(link.attributes);
                this.str.append('\n');
            }
        }
    }

    private void linkTarget(Object linkable) {
        if (linkable instanceof MutableNodePoint) {
            this.point((MutableNodePoint)linkable);
        } else if (linkable instanceof MutableGraph) {
            this.graph((MutableGraph)linkable, false);
        } else {
            throw new IllegalStateException("unexpected link target " + linkable);
        }
    }

    private void node(MutableNode node) {
        this.str.append(node.label.serialized());
        this.attrs(node.attributes);
    }

    private void point(MutableNodePoint point) {
        this.str.append(point.node.label.serialized());
        if (point.record != null) {
            this.str.append(':');
            this.str.append(Label.of(point.record).serialized());
        }
        if (point.compass != null) {
            this.str.append(':').append(point.compass.value);
        }
    }

    private void attrs(MutableAttributed<?> attrs) {
        if (!attrs.isEmpty()) {
            this.str.append(" [");
            boolean first = true;
            for (Map.Entry entry : attrs) {
                if (first) {
                    first = false;
                } else {
                    this.str.append(',');
                }
                this.attr((String)entry.getKey(), entry.getValue());
            }
            this.str.append(']');
        }
    }

    private void attr(String key, Object value) {
        this.str.append(Label.of(key).serialized()).append('=').append((value instanceof Label ? (Label)value : Label.of(value.toString())).serialized());
    }
}

