/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.model.Compass;
import guru.nidi.graphviz.model.CreationContext;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.ImmutableGraph;
import guru.nidi.graphviz.model.ImmutableNode;
import guru.nidi.graphviz.model.ImmutableNodePoint;
import guru.nidi.graphviz.model.Label;
import guru.nidi.graphviz.model.Link;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.MutableNode;
import guru.nidi.graphviz.model.MutableNodePoint;
import guru.nidi.graphviz.model.Node;
import guru.nidi.graphviz.model.NodePoint;

public final class Factory {
    private Factory() {
    }

    public static Graph graph() {
        return Factory.graph("");
    }

    public static Graph graph(String name) {
        return Factory.graph(Factory.name(name));
    }

    public static Graph graph(Label label) {
        return new ImmutableGraph().labeled(label);
    }

    public static Node node(String name) {
        return Factory.node(Label.of(name));
    }

    public static Node node(Label label) {
        return CreationContext.current().map(ctx -> ctx.immutableNode(label)).orElseGet(() -> new ImmutableNode(label));
    }

    public static NodePoint loc(String record) {
        return Factory.loc(record, null);
    }

    public static NodePoint loc(Compass compass) {
        return Factory.loc(null, compass);
    }

    public static NodePoint loc(String record, Compass compass) {
        return new ImmutableNodePoint(null, record, compass);
    }

    public static MutableGraph mutGraph() {
        return new MutableGraph();
    }

    public static MutableGraph mutGraph(String name) {
        return new MutableGraph().setLabel(name);
    }

    public static MutableGraph mutGraph(Label label) {
        return new MutableGraph().setLabel(label);
    }

    public static MutableNode mutNode(String name) {
        return Factory.mutNode(Label.of(name));
    }

    public static MutableNode mutNode(Label label) {
        return CreationContext.current().map(ctx -> ctx.mutableNode(label)).orElseGet(() -> new MutableNode().setLabel(label));
    }

    public static MutableNodePoint mutLoc(String record) {
        return new MutableNodePoint().setRecord(record);
    }

    public static MutableNodePoint mutLoc(Compass compass) {
        return new MutableNodePoint().setCompass(compass);
    }

    public static MutableNodePoint mutLoc(String record, Compass compass) {
        return new MutableNodePoint().setRecord(record).setCompass(compass);
    }

    public static Label name(String name) {
        return Label.of(name);
    }

    public static Label html(String html) {
        return Label.html(html);
    }

    public static Link to(Node node) {
        return Link.to(node);
    }

    public static Link to(LinkTarget node) {
        return Link.to(node);
    }

    public static Link between(LinkSource from, LinkTarget to) {
        return Link.between(from, to);
    }
}

