/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.GraphvizException;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import javax.imageio.ImageIO;

public class Renderer {
    private final Graphviz graphviz;
    private final Consumer<Graphics2D> graphicsConfigurer;

    Renderer(Graphviz graphviz, Consumer<Graphics2D> graphicsConfigurer) {
        this.graphviz = graphviz;
        this.graphicsConfigurer = graphicsConfigurer;
    }

    public Renderer withGraphics(Consumer<Graphics2D> graphicsConfigurer) {
        return new Renderer(this.graphviz, graphicsConfigurer);
    }

    public String toString() {
        return this.graphviz.execute();
    }

    public void toFile(File file) throws IOException {
        Files.createDirectories(file.getAbsoluteFile().getParentFile().toPath(), new FileAttribute[0]);
        if (this.graphviz.format().image) {
            this.writeToFile(file, this.graphviz.format().name().toLowerCase(), this.toImage());
        } else {
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                out.write(this.toString());
            }
        }
    }

    public void toOutputStream(OutputStream outputStream) throws IOException {
        if (this.graphviz.format().image) {
            this.writeToOutputStream(outputStream, this.graphviz.format().name().toLowerCase(), this.toImage());
        } else {
            try (OutputStreamWriter out = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
                out.write(this.toString());
            }
        }
    }

    public BufferedImage toImage() {
        if (!this.graphviz.format().svg) {
            throw new IllegalStateException("Images can only be rendered from PNG and SVG formats.");
        }
        String svg = this.graphviz.execute().replace("stroke=\"transparent\"", "stroke=\"#fff\" stroke-opacity=\"0.0\"");
        return this.graphviz.rasterizer.render(this.graphviz, this.graphicsConfigurer, svg);
    }

    private void writeToFile(File output, String format, BufferedImage img) {
        try {
            ImageIO.write((RenderedImage)img, format, output);
        }
        catch (IOException e) {
            throw new GraphvizException("Problem writing to file", e);
        }
    }

    private void writeToOutputStream(OutputStream outputStream, String format, BufferedImage img) {
        try (OutputStream closing = outputStream;){
            ImageIO.write((RenderedImage)img, format, closing);
        }
        catch (IOException e) {
            throw new GraphvizException("Problem writing to output stream", e);
        }
    }
}

