/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.GraphvizException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class GraphvizLoader {
    private static Supplier<ClassLoader> classLoaderSupplier = GraphvizLoader.class::getClassLoader;

    private GraphvizLoader() {
    }

    public static void useClassLoader(Supplier<ClassLoader> supplier) {
        classLoaderSupplier = supplier;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadAsString(String name) {
        try (InputStream in = GraphvizLoader.load(name);){
            if (in == null) {
                throw new GraphvizException("Could not find resource '" + name + "' on the classpath.");
            }
            String string = GraphvizLoader.readAsString(in);
            return string;
        }
        catch (IOException e) {
            throw new GraphvizException("Problem reading resource '" + name + "' from the classpath.", e);
        }
    }

    static String readAsString(InputStream in) throws IOException {
        return new String(GraphvizLoader.readAsBytes(in), StandardCharsets.UTF_8);
    }

    static byte[] readAsBytes(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream res = new ByteArrayOutputStream();
        byte[] buf = new byte[100000];
        while ((read = in.read(buf)) > 0) {
            res.write(buf, 0, read);
        }
        res.flush();
        return res.toByteArray();
    }

    static boolean isOnClasspath(String resource) {
        return GraphvizLoader.classLoader().getResource(resource) != null;
    }

    static ClassLoader classLoader() {
        return classLoaderSupplier.get();
    }

    static void closeQuietly(AutoCloseable c) {
        try {
            c.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    private static InputStream load(String name) {
        return GraphvizLoader.classLoader().getResourceAsStream(name);
    }
}

