/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.AbstractGraphvizEngine;
import guru.nidi.graphviz.engine.BuiltInRasterizer;
import guru.nidi.graphviz.engine.EngineResult;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.GraphvizLoader;
import guru.nidi.graphviz.engine.MissingDependencyException;
import guru.nidi.graphviz.engine.Options;
import guru.nidi.graphviz.engine.Rasterizer;
import guru.nidi.graphviz.engine.StringFunctions;
import guru.nidi.graphviz.engine.TempFiles;
import guru.nidi.graphviz.service.CommandBuilder;
import guru.nidi.graphviz.service.CommandLineExecutor;
import guru.nidi.graphviz.service.CommandRunner;
import guru.nidi.graphviz.service.SystemUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphvizCmdLineEngine
extends AbstractGraphvizEngine {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractGraphvizEngine.class);
    static final boolean AVAILABLE = GraphvizLoader.isOnClasspath("org/apache/commons/exec/CommandLine.class");
    @Nullable
    private final String executable;
    private final String envPath;
    private final CommandRunner cmdRunner;
    @Nullable
    private String outputFilePath;
    @Nullable
    private String outputFileName;

    public GraphvizCmdLineEngine() {
        this(null, Optional.ofNullable(System.getenv("PATH")).orElse(""), GraphvizCmdLineEngine.runner(GraphvizCmdLineEngine.defaultExecutor()));
    }

    public GraphvizCmdLineEngine(String executable) {
        this(executable, Optional.ofNullable(System.getenv("PATH")).orElse(""), GraphvizCmdLineEngine.runner(GraphvizCmdLineEngine.defaultExecutor()));
    }

    private GraphvizCmdLineEngine(@Nullable String executable, String envPath, CommandRunner cmdRunner) {
        super(true);
        this.executable = executable;
        this.envPath = envPath;
        this.cmdRunner = cmdRunner;
    }

    public GraphvizCmdLineEngine searchPath(String path) {
        return new GraphvizCmdLineEngine(this.executable, path, this.cmdRunner);
    }

    public GraphvizCmdLineEngine executor(CommandLineExecutor executor) {
        return new GraphvizCmdLineEngine(this.executable, this.envPath, GraphvizCmdLineEngine.runner(executor));
    }

    private static CommandRunner runner(CommandLineExecutor executor) {
        return new CommandBuilder().withShellWrapper(true).withCommandExecutor(executor).build();
    }

    private static CommandLineExecutor defaultExecutor() {
        if (!AVAILABLE) {
            throw new MissingDependencyException("Command line engine is not available.", "org.apache.commons:commons-exec");
        }
        return new CommandLineExecutor();
    }

    public GraphvizCmdLineEngine timeout(int amount, TimeUnit unit) {
        return (GraphvizCmdLineEngine)super.timeout(amount, unit);
    }

    @Override
    protected void doInit() {
        this.getEngineExecutable();
    }

    @Override
    public EngineResult execute(String src, Options options, Rasterizer rasterizer) {
        try {
            Path path = TempFiles.tempDir("DotEngine");
            File dotFile = this.getDotFile(path);
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dotFile), StandardCharsets.UTF_8));){
                bw.write(this.preprocessCode(src, options));
            }
            return this.doExecute(path, dotFile, options, rasterizer);
        }
        catch (IOException | InterruptedException e) {
            throw new GraphvizException(e.getMessage(), e);
        }
    }

    private EngineResult doExecute(Path path, File dotFile, Options options, Rasterizer rasterizer) throws IOException, InterruptedException {
        String simpleFormat = this.simpleFormat(options.format, rasterizer);
        String command = this.getEngineExecutable() + (options.yInvert != null && options.yInvert != false ? " -y" : "") + " -K" + options.engine.toString().toLowerCase(Locale.ENGLISH) + " -T" + this.completeFormat(options.format, rasterizer) + " " + dotFile.getAbsolutePath() + " -ooutfile." + simpleFormat;
        this.cmdRunner.exec(command, path.toFile(), this.timeout, new String[0]);
        Path outFile = path.resolve("outfile." + simpleFormat);
        if (rasterizer instanceof BuiltInRasterizer) {
            return EngineResult.fromFile(outFile.toFile());
        }
        byte[] data = Files.readAllBytes(outFile);
        return EngineResult.fromString(new String(data, StandardCharsets.UTF_8));
    }

    protected String preprocessCode(String src, Options options) {
        return StringFunctions.replaceRegex(StringFunctions.replaceRegex(src, IMG_SRC, path -> options.image((String)path).processImagePath((String)path)), IMAGE_ATTR, path -> options.image((String)path).processImagePath((String)path));
    }

    private String getEngineExecutable() {
        if (this.executable != null) {
            if (CommandRunner.isExecutableFile(SystemUtils.pathOf(this.executable)) || CommandRunner.isExecutableFound(this.executable, this.envPath)) {
                return this.executable;
            }
            LOG.warn("Executable '" + this.executable + "' not found directly and not on PATH. Trying with 'dot'.");
        }
        List<String> exes = SystemUtils.executableNames("dot");
        for (String exe : exes) {
            if (!CommandRunner.isExecutableFound(exe, this.envPath)) continue;
            return exe;
        }
        GraphvizException e = new GraphvizException(exes + " command not found");
        e.setStackTrace(new StackTraceElement[0]);
        throw e;
    }

    private String simpleFormat(Format format, Rasterizer rasterizer) {
        return rasterizer instanceof BuiltInRasterizer ? ((BuiltInRasterizer)rasterizer).format : format.vizName;
    }

    private String completeFormat(Format format, Rasterizer rasterizer) {
        if (rasterizer instanceof BuiltInRasterizer) {
            BuiltInRasterizer natRast = (BuiltInRasterizer)rasterizer;
            String f = natRast.format;
            if (natRast.renderer != null) {
                f = f + ":" + natRast.renderer;
            }
            if (natRast.formatter != null) {
                f = f + ":" + natRast.formatter;
            }
            return f;
        }
        return format.vizName;
    }

    private File getDotFile(Path path) {
        String dotFileName = this.outputFileName == null ? "dotfile.dot" : this.outputFileName + ".dot";
        String baseDir = this.outputFilePath == null ? path.toString() : this.outputFilePath;
        return new File(baseDir, dotFileName);
    }

    public void setDotOutputFile(String path, String name) {
        this.outputFilePath = path;
        this.outputFileName = name;
    }
}

