/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.parse;

import guru.nidi.graphviz.attribute.validate.AttributeValidator;
import guru.nidi.graphviz.attribute.validate.ValidatorMessage;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.parse.Lexer;
import guru.nidi.graphviz.parse.ParserImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Parser {
    private static final Logger LOG = LoggerFactory.getLogger(Parser.class);
    @Nullable
    private final String engine;
    @Nullable
    private final String format;
    private final Consumer<ValidatorMessage> messageConsumer;

    public Parser() {
        this(null, null, msg -> LOG.info(String.format("%-7s %-15.15s at %3d:%-3d %s", new Object[]{msg.severity, msg.attribute, msg.line, msg.column, msg.message})));
    }

    private Parser(@Nullable String engine, @Nullable String format, Consumer<ValidatorMessage> messageConsumer) {
        this.engine = engine;
        this.format = format;
        this.messageConsumer = messageConsumer;
    }

    public Parser forEngine(@Nullable String engine) {
        return new Parser(engine, this.format, this.messageConsumer);
    }

    public Parser forFormat(@Nullable String format) {
        return new Parser(this.engine, format, this.messageConsumer);
    }

    public Parser messageConsumer(Consumer<ValidatorMessage> messageConsumer) {
        return new Parser(this.engine, this.format, messageConsumer);
    }

    public MutableGraph read(File file) throws IOException {
        return this.read(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8), file.getName());
    }

    public MutableGraph read(InputStream is) throws IOException {
        return this.read(new InputStreamReader(is, StandardCharsets.UTF_8), "<input stream>");
    }

    public MutableGraph read(String dot) throws IOException {
        return this.read(new StringReader(dot), "<string>");
    }

    public MutableGraph read(Reader dot, String name) throws IOException {
        return new ParserImpl(new Lexer(dot, name), new AttributeValidator(this.engine, this.format), this.messageConsumer).parse();
    }
}

