/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.AbstractGraphvizEngine;
import guru.nidi.graphviz.engine.BuiltInRasterizer;
import guru.nidi.graphviz.engine.EngineResult;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.IoUtils;
import guru.nidi.graphviz.engine.JavascriptEngine;
import guru.nidi.graphviz.engine.Options;
import guru.nidi.graphviz.engine.Rasterizer;
import guru.nidi.graphviz.service.SystemUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public abstract class AbstractJsGraphvizEngine
extends AbstractGraphvizEngine {
    private static final Map<Class<?>, ThreadLocal<JavascriptEngine>> ENGINES = new HashMap();
    private final Supplier<JavascriptEngine> engineSupplier;

    protected AbstractJsGraphvizEngine(boolean sync, Supplier<JavascriptEngine> engineSupplier) {
        super(sync);
        this.engineSupplier = engineSupplier;
    }

    @Override
    protected void doInit() {
        this.engine().executeJavascript(this.vizJsCode());
        this.engine().executeJavascript(this.renderJsCode());
        this.execute("graph g { a -- b }", Options.create(), null);
    }

    protected JavascriptEngine engine() {
        ThreadLocal holder = ENGINES.computeIfAbsent(this.getClass(), e -> new ThreadLocal());
        JavascriptEngine engine = (JavascriptEngine)holder.get();
        if (engine == null) {
            engine = this.engineSupplier.get();
            holder.set(engine);
            this.throwingInit();
        }
        return engine;
    }

    @Override
    public void close() {
        JavascriptEngine engine;
        ThreadLocal<JavascriptEngine> holder = ENGINES.get(this.getClass());
        if (holder != null && (engine = holder.get()) != null) {
            IoUtils.closeQuietly(engine);
            holder.remove();
        }
    }

    @Override
    public EngineResult execute(String src, Options options, @Nullable Rasterizer rasterizer) {
        if (rasterizer instanceof BuiltInRasterizer) {
            throw new GraphvizException("Built-in Rasterizer can only be used together with GraphvizCmdLineEngine.");
        }
        return EngineResult.fromString(this.jsVizExec(src, options));
    }

    protected String jsVizExec(String src, Options options) {
        if (src.startsWith("totalMemory") || src.startsWith("render")) {
            return src;
        }
        String memory = options.totalMemory == null ? "" : "totalMemory=" + options.totalMemory + ";";
        Map.Entry<String, Options> srcAndOpts = this.preprocessCode(src, options);
        return this.engine().executeJavascript(memory + "render(", srcAndOpts.getKey(), "," + srcAndOpts.getValue().toJson(false) + ");");
    }

    protected Map.Entry<String, Options> preprocessCode(String src, Options options) {
        if (src.contains("<img")) {
            throw new GraphvizException("Found <img> tag. This is not supported by JS engines. Either use the GraphvizCmdLineEngine or a node with image attribute.");
        }
        Options[] opts = new Options[]{options};
        String pathsReplaced = this.replacePaths(src, IMAGE_ATTR, path -> {
            String realPath = SystemUtils.uriPathOf(this.replacePath((String)path, options.basedir));
            opts[0] = opts[0].image(realPath);
            return realPath;
        });
        return new AbstractMap.SimpleEntry<String, Options>(pathsReplaced, opts[0]);
    }

    /*
     * Exception decompiling
     */
    private String vizJsCode() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String promiseJsCode() {
        try (InputStream api = this.getClass().getResourceAsStream("/net/arnx/nashorn/lib/promise.js");){
            String string = IoUtils.readStream(api);
            return string;
        }
        catch (IOException e) {
            throw new AssertionError("Could not load internal javascript resources, is the jar file corrupt?", e);
        }
    }

    private String renderJsCode() {
        return "var viz; var totalMemory = 16777216;function initViz(force){  if (force || !viz || viz.totalMemory !== totalMemory){    viz = new Viz({      Module: function(){ return Viz.Module({TOTAL_MEMORY: totalMemory}); },      render: Viz.render    });    viz.totalMemory = totalMemory;  }  return viz;}function render(src, options){  try {    initViz().renderString(src, options)      .then(function(res) { result(res); })      .catch(function(err) { initViz(true); error(err.toString()); });  } catch(e) { error(e.toString()); }}";
    }
}

