/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute.validate;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.For;
import guru.nidi.graphviz.attribute.validate.AttributeConfig;
import guru.nidi.graphviz.attribute.validate.AttributeConfigs;
import guru.nidi.graphviz.attribute.validate.Datatype;
import guru.nidi.graphviz.attribute.validate.ValidatorMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class AttributeValidator {
    @Nullable
    private final AttributeConfig.Engine engine;
    @Nullable
    private final AttributeConfig.Format format;

    public AttributeValidator(@Nullable String engine, @Nullable String format) {
        this.engine = engine == null ? null : AttributeConfig.Engine.valueOf(engine.toUpperCase(Locale.ENGLISH));
        this.format = format == null ? null : AttributeConfig.Format.valueOf(format.toUpperCase(Locale.ENGLISH));
    }

    public List<ValidatorMessage> validate(Attributes<? extends For> attrs, Scope scope) {
        return StreamSupport.stream(attrs.spliterator(), false).flatMap(entry -> this.validate((String)entry.getKey(), entry.getValue(), scope).stream()).collect(Collectors.toList());
    }

    public List<ValidatorMessage> validate(String key, Object value, Scope scope) {
        List<AttributeConfig> configs = AttributeConfigs.get(key);
        if (configs == null) {
            return Collections.singletonList(new ValidatorMessage(ValidatorMessage.Severity.ERROR, key, "Attribute is unknown."));
        }
        AttributeConfig engineConfig = this.findConfigForEngine(configs);
        if (engineConfig == null) {
            return Collections.singletonList(new ValidatorMessage(ValidatorMessage.Severity.ERROR, key, "Attribute is not allowed for engine '" + (Object)((Object)this.engine) + "'."));
        }
        AttributeConfig formatConfig = this.findConfigForFormat(configs);
        if (formatConfig == null) {
            return Collections.singletonList(new ValidatorMessage(ValidatorMessage.Severity.ERROR, key, "Attribute is not allowed for format '" + (Object)((Object)this.format) + "'."));
        }
        if (!engineConfig.equals(formatConfig)) {
            return Collections.singletonList(new ValidatorMessage(ValidatorMessage.Severity.ERROR, key, "Attribute is not allowed for engine '" + (Object)((Object)this.engine) + "' and format '" + (Object)((Object)this.format) + "'."));
        }
        List<ValidatorMessage> messages = this.validateNonType(key, value, scope, engineConfig);
        messages.addAll(this.validateType(key, value, engineConfig));
        return messages;
    }

    private AttributeConfig findConfigForEngine(List<AttributeConfig> configs) {
        return configs.stream().filter(c -> {
            if (this.engine == null || c.engines.isEmpty()) {
                return true;
            }
            if (c.engines.contains((Object)AttributeConfig.Engine.NOT_DOT) && this.engine == AttributeConfig.Engine.DOT) {
                return false;
            }
            return c.engines.contains((Object)this.engine);
        }).findFirst().orElse(null);
    }

    private AttributeConfig findConfigForFormat(List<AttributeConfig> configs) {
        return configs.stream().filter(c -> this.format == null || c.formats.isEmpty() || c.formats.contains((Object)this.format)).findFirst().orElse(null);
    }

    private List<ValidatorMessage> validateNonType(String key, Object value, Scope scope, AttributeConfig config) {
        ArrayList<ValidatorMessage> messages = new ArrayList<ValidatorMessage>();
        if (!config.scopes.contains((Object)scope)) {
            messages.add(new ValidatorMessage(ValidatorMessage.Severity.ERROR, key, "Attribute is not allowed for scope '" + (Object)((Object)scope) + "'."));
        }
        if (config.defVal != null && this.isValueEquals(config.defVal, value)) {
            messages.add(new ValidatorMessage(ValidatorMessage.Severity.WARNING, key, "Attribute is set to its default value '" + config.defVal + "'."));
        }
        Double val = Datatype.tryParseDouble(value.toString());
        if (config.min != null && val != null && val < config.min) {
            messages.add(new ValidatorMessage(ValidatorMessage.Severity.WARNING, key, "Attribute has a minimum of '" + config.min + "' but is set to '" + value + "'."));
        }
        return messages;
    }

    private List<ValidatorMessage> validateType(String key, Object value, AttributeConfig config) {
        List typeMessages = config.types.stream().map(t -> t.validate(value)).collect(Collectors.toList());
        if (typeMessages.size() == 1) {
            if (typeMessages.get(0) != null) {
                return Collections.singletonList(((ValidatorMessage)typeMessages.get(0)).at(key));
            }
        } else if (typeMessages.stream().noneMatch(Objects::isNull)) {
            return Collections.singletonList(new ValidatorMessage(ValidatorMessage.Severity.ERROR, key, "'" + value + "' is not valid for any of the types '" + config.types.stream().map(t -> t.name).collect(Collectors.joining(", ")) + "'."));
        }
        return Collections.emptyList();
    }

    private boolean isValueEquals(Object config, Object value) {
        if (config instanceof Double) {
            Double val = Datatype.doubleValue(value);
            return val != null && Math.abs((Double)config - val) < 1.0E-4;
        }
        if (config instanceof Integer) {
            Integer val = Datatype.intValue(value);
            return val != null && val.equals(config);
        }
        if (config instanceof Boolean) {
            Boolean val = Datatype.boolValue(value);
            return val != null && val.equals(config);
        }
        return config.toString().equals(value.toString());
    }

    public static enum Scope {
        GRAPH,
        SUB_GRAPH,
        CLUSTER,
        NODE,
        EDGE;

    }
}

