/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.pmd;

import guru.nidi.codeassert.AnalyzerException;
import guru.nidi.codeassert.pmd.PropertyField;
import java.lang.reflect.Field;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSets;

public class PmdRuleset {
    final String name;

    public PmdRuleset(String name) {
        this.name = name;
    }

    public void apply(RuleSets ruleSets) {
        for (Field descField : this.getClass().getDeclaredFields()) {
            PropertyField propertyField = descField.getAnnotation(PropertyField.class);
            if (propertyField == null) continue;
            try {
                descField.setAccessible(true);
                Object value = descField.get(this);
                if (value == null) continue;
                this.setProperty(ruleSets, propertyField.rule(), propertyField.property(), value);
            }
            catch (IllegalAccessException e) {
                throw new AnalyzerException("Could not read property " + descField.getName() + " from class " + this.getClass(), e);
            }
        }
    }

    private void setProperty(RuleSets ruleSets, String rule, String property, Object value) {
        Rule r = ruleSets.getRuleByName(rule);
        if (r == null) {
            throw new AnalyzerException("Rule '" + rule + "' not existing.");
        }
        PropertyDescriptor descriptor = r.getPropertyDescriptor(property);
        if (descriptor == null) {
            throw new AnalyzerException("Property '" + property + "' for rule '" + rule + "' not existing.");
        }
        r.setProperty(descriptor, value);
    }
}

