/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.pmd;

import guru.nidi.codeassert.Analyzer;
import guru.nidi.codeassert.AnalyzerException;
import guru.nidi.codeassert.config.AnalyzerConfig;
import guru.nidi.codeassert.config.Language;
import guru.nidi.codeassert.config.UsageCounter;
import guru.nidi.codeassert.pmd.PmdResult;
import guru.nidi.codeassert.pmd.PmdRuleset;
import guru.nidi.codeassert.pmd.PmdViolationCollector;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSetReferenceId;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.lang.LanguageFilenameFilter;
import net.sourceforge.pmd.lang.java.JavaLanguageModule;
import net.sourceforge.pmd.processor.MonoThreadProcessor;
import net.sourceforge.pmd.processor.MultiThreadProcessor;
import net.sourceforge.pmd.renderers.AbstractAccumulatingRenderer;
import net.sourceforge.pmd.util.FileUtil;
import net.sourceforge.pmd.util.datasource.DataSource;
import org.apache.commons.io.output.NullWriter;

public class PmdAnalyzer
implements Analyzer<List<RuleViolation>> {
    private static final Comparator<RuleViolation> VIOLATION_SORTER = Comparator.comparingInt(v -> v.getRule().getPriority().getPriority()).thenComparing(v -> v.getRule().getName());
    private final AnalyzerConfig config;
    private final PmdViolationCollector collector;
    private final Map<String, PmdRuleset> rulesets;

    public PmdAnalyzer(AnalyzerConfig config, PmdViolationCollector collector) {
        this(config, new HashMap<String, PmdRuleset>(), collector);
    }

    private PmdAnalyzer(AnalyzerConfig config, Map<String, PmdRuleset> rulesets, PmdViolationCollector collector) {
        this.config = config;
        this.collector = collector;
        this.rulesets = rulesets;
    }

    public PmdAnalyzer withRulesets(PmdRuleset ... rulesets) {
        HashMap<String, PmdRuleset> newRuleset = new HashMap<String, PmdRuleset>(this.rulesets);
        for (PmdRuleset ruleset : rulesets) {
            newRuleset.put(ruleset.name, ruleset);
        }
        return new PmdAnalyzer(this.config, newRuleset, this.collector);
    }

    public PmdAnalyzer withoutRulesets(PmdRuleset ... rulesets) {
        HashMap<String, PmdRuleset> newRuleset = new HashMap<String, PmdRuleset>(this.rulesets);
        for (PmdRuleset ruleset : rulesets) {
            newRuleset.remove(ruleset.name);
        }
        return new PmdAnalyzer(this.config, newRuleset, this.collector);
    }

    public PmdResult analyze() {
        if (this.rulesets.isEmpty()) {
            throw new AnalyzerException("No rulesets defined. Use the withRulesets methods to define some. See Rulesets class for predefined rule sets.");
        }
        PMDConfiguration pmdConfig = this.createPmdConfig();
        RuleSetFactory ruleSetFactory = this.createRuleSetFactory(pmdConfig);
        List files = FileUtil.collectFiles((String)pmdConfig.getInputPaths(), (FilenameFilter)new LanguageFilenameFilter((net.sourceforge.pmd.lang.Language)new JavaLanguageModule()));
        return this.runPmd(pmdConfig, ruleSetFactory, files);
    }

    private PMDConfiguration createPmdConfig() {
        PMDConfiguration pmdConfig = new PMDConfiguration();
        StringBuilder inputs = new StringBuilder();
        for (AnalyzerConfig.Path source : this.config.getSourcePaths(new Language[0])) {
            inputs.append(',').append(source.getPath());
        }
        pmdConfig.setInputPaths(inputs.substring(1));
        pmdConfig.setRuleSets(this.ruleSetNames());
        pmdConfig.setThreads(0);
        return pmdConfig;
    }

    private String ruleSetNames() {
        StringBuilder s = new StringBuilder();
        for (PmdRuleset ruleset : this.rulesets.values()) {
            s.append(',').append(ruleset.name);
        }
        return this.rulesets.isEmpty() ? "" : s.substring(1);
    }

    private RuleSetFactory createRuleSetFactory(PMDConfiguration pmdConfig) {
        return new RuleSetFactory(PmdAnalyzer.class.getClassLoader(), pmdConfig.getMinimumPriority(), true, pmdConfig.isRuleSetFactoryCompatibilityEnabled()){

            public synchronized RuleSets createRuleSets(List<RuleSetReferenceId> ruleSetReferenceIds) throws RuleSetNotFoundException {
                RuleSets sets = super.createRuleSets(ruleSetReferenceIds);
                for (PmdRuleset ruleset : PmdAnalyzer.this.rulesets.values()) {
                    ruleset.apply(sets);
                }
                return sets;
            }
        };
    }

    private PmdResult runPmd(PMDConfiguration pmdConfig, RuleSetFactory ruleSetFactory, List<DataSource> files) {
        try {
            PmdRenderer renderer = new PmdRenderer();
            renderer.start();
            RuleContext ctx = new RuleContext();
            if (pmdConfig.getThreads() > 0) {
                new MultiThreadProcessor(pmdConfig).processFiles(ruleSetFactory, files, ctx, Collections.singletonList(renderer));
            } else {
                new MonoThreadProcessor(pmdConfig).processFiles(ruleSetFactory, files, ctx, Collections.singletonList(renderer));
            }
            renderer.end();
            renderer.flush();
            return this.processViolations(renderer);
        }
        catch (IOException e) {
            throw new AnalyzerException("Problem running PMD", e);
        }
    }

    private PmdResult processViolations(PmdRenderer renderer) {
        UsageCounter counter = new UsageCounter();
        List<RuleViolation> violations = this.asStream(renderer.getReport()).filter(v -> counter.accept(this.collector.accept((RuleViolation)v))).sorted(VIOLATION_SORTER).collect(Collectors.toList());
        this.collector.printUnusedWarning(counter);
        return new PmdResult(this, violations, this.collector.unusedActions(counter));
    }

    private Stream<RuleViolation> asStream(Report report) {
        return report == null ? Stream.empty() : StreamSupport.stream(report.spliterator(), false);
    }

    private static class PmdRenderer
    extends AbstractAccumulatingRenderer {
        PmdRenderer() {
            super("", "");
            super.setWriter((Writer)new NullWriter());
        }

        public String defaultFileExtension() {
            return null;
        }

        public void end() {
        }

        public Report getReport() {
            return this.report;
        }
    }
}

