/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.model;

import java.io.DataInputStream;
import java.io.IOException;

final class Constant {
    static final int UTF8 = 1;
    static final int UNICODE = 2;
    static final int INTEGER = 3;
    static final int FLOAT = 4;
    static final int LONG = 5;
    static final int DOUBLE = 6;
    static final int CLASS = 7;
    static final int STRING = 8;
    static final int FIELD = 9;
    static final int METHOD = 10;
    static final int INTERFACEMETHOD = 11;
    static final int NAMEANDTYPE = 12;
    static final int METHOD_HANDLE = 15;
    static final int METHOD_TYPE = 16;
    static final int INVOKEDYNAMIC = 18;
    final byte tag;
    final int nameIndex;
    final int typeIndex;
    final Object value;

    static Constant fromData(DataInputStream in) throws IOException {
        byte tag = in.readByte();
        switch (tag) {
            case 7: 
            case 8: 
            case 16: {
                return new Constant(tag, in.readUnsignedShort());
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: {
                return new Constant(tag, in.readUnsignedShort(), in.readUnsignedShort());
            }
            case 3: {
                return new Constant(tag, in.readInt());
            }
            case 4: {
                return new Constant(tag, Float.valueOf(in.readFloat()));
            }
            case 5: {
                return new Constant(tag, in.readLong());
            }
            case 6: {
                return new Constant(tag, in.readDouble());
            }
            case 1: {
                return new Constant(tag, in.readUTF());
            }
            case 15: {
                return new Constant(tag, in.readByte(), in.readUnsignedShort());
            }
        }
        throw new IOException("Unknown constant: " + tag);
    }

    private Constant(byte tag, int nameIndex) {
        this(tag, nameIndex, -1, null);
    }

    private Constant(byte tag, Object value) {
        this(tag, -1, -1, value);
    }

    private Constant(byte tag, int nameIndex, int typeIndex) {
        this(tag, nameIndex, typeIndex, null);
    }

    private Constant(byte tag, int nameIndex, int typeIndex, Object value) {
        this.tag = tag;
        this.nameIndex = nameIndex;
        this.typeIndex = typeIndex;
        this.value = value;
    }

    boolean isBig() {
        return this.tag == 6 || this.tag == 5;
    }
}

