/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.model;

import guru.nidi.codeassert.model.ConstantPool;
import java.io.DataInputStream;
import java.io.IOException;

final class AttributeInfo {
    final String name;
    final byte[] value;

    private AttributeInfo(String name, byte[] value) {
        this.name = name;
        this.value = value;
    }

    public static AttributeInfo fromData(DataInputStream in, ConstantPool constantPool) throws IOException {
        int nameIndex = in.readUnsignedShort();
        String name = nameIndex == -1 ? null : constantPool.getUtf8(nameIndex);
        int attributeLength = in.readInt();
        byte[] value = new byte[attributeLength];
        for (int b = 0; b < attributeLength; ++b) {
            value[b] = in.readByte();
        }
        return new AttributeInfo(name, value);
    }

    public boolean isAnnotation() {
        return "RuntimeVisibleAnnotations".equals(this.name) || "RuntimeInvisibleAnnotations".equals(this.name);
    }

    public boolean isSignature() {
        return "Signature".equals(this.name);
    }

    public boolean isSource() {
        return "SourceFile".equals(this.name);
    }

    public boolean isCode() {
        return "Code".equals(this.name);
    }

    public String sourceFile(ConstantPool constantPool) throws IOException {
        int b0 = this.value[0] < 0 ? this.value[0] + 256 : this.value[0];
        int b1 = this.value[1] < 0 ? this.value[1] + 256 : this.value[1];
        int pe = b0 * 256 + b1;
        return constantPool.getUtf8(pe);
    }
}

