/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.junit;

import guru.nidi.codeassert.checkstyle.StyleChecks;
import guru.nidi.codeassert.config.CollectorTemplate;
import guru.nidi.codeassert.config.Ignore;
import guru.nidi.codeassert.config.In;
import guru.nidi.codeassert.config.Language;
import guru.nidi.codeassert.findbugs.BugCollector;
import guru.nidi.codeassert.pmd.CpdMatchCollector;
import guru.nidi.codeassert.pmd.PmdRuleset;
import guru.nidi.codeassert.pmd.PmdRulesets;
import guru.nidi.codeassert.pmd.PmdViolationCollector;

public final class PredefConfig {
    private static final String VARIABLE_PATTERN = "^[a-z][a-zA-Z0-9]*$";

    private PredefConfig() {
    }

    public static CollectorTemplate<Ignore> minimalPmdIgnore() {
        return (CollectorTemplate)((CollectorTemplate)((CollectorTemplate)((CollectorTemplate)CollectorTemplate.forA(PmdViolationCollector.class).because("junit", new Ignore[]{In.classes("*Test", "Test*").ignore("JUnitSpelling", "JUnitAssertionsShouldIncludeMessage", "AvoidDuplicateLiterals", "SignatureDeclareThrowsException", "TooManyStaticImports")})).because("I don't agree", new Ignore[]{In.everywhere().ignore("MethodArgumentCouldBeFinal", "AvoidFieldNameMatchingMethodName", "CommentDefaultAccessModifier", "AbstractNaming", "AvoidFieldNameMatchingTypeName", "UncommentedEmptyConstructor", "UseStringBufferForStringAppends", "UncommentedEmptyMethodBody", "EmptyMethodInAbstractClassShouldBeAbstract", "InefficientEmptyStringCheck")})).because("it's equals", new Ignore[]{In.methods("equals").ignore("NPathComplexity", "ModifiedCyclomaticComplexity", "StdCyclomaticComplexity", "CyclomaticComplexity", "ConfusingTernary")})).because("it's hashCode", new Ignore[]{In.methods("hashCode").ignore("ConfusingTernary")});
    }

    public static CollectorTemplate<Ignore> dependencyTestIgnore(Class<?> dependencyTest) {
        return (CollectorTemplate)CollectorTemplate.of(Ignore.class).just(new Ignore[]{In.clazz(dependencyTest).ignore("AvoidDollarSigns", "VariableNamingConventions", "SuspiciousConstantFieldName", "NP_UNWRITTEN_FIELD", "UWF_UNWRITTEN_FIELD", "UUF_UNUSED_FIELD")});
    }

    public static CollectorTemplate<Ignore> cpdIgnoreEqualsHashCodeToString() {
        return (CollectorTemplate)CollectorTemplate.forA(CpdMatchCollector.class).because("equals, hashCode, toString sometimes look the same", new Ignore[]{In.everywhere().ignore("public boolean equals(Object", "public int hashCode()", "public String toString()")});
    }

    public static CollectorTemplate<Ignore> minimalFindBugsIgnore() {
        return (CollectorTemplate)((CollectorTemplate)((CollectorTemplate)((CollectorTemplate)((CollectorTemplate)CollectorTemplate.forA(BugCollector.class).because("modern compilers are clever", new Ignore[]{In.everywhere().ignore("SBSC_USE_STRINGBUFFER_CONCATENATION")})).because("it's compiler generated code", new Ignore[]{In.languages(Language.KOTLIN).ignore("ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD", "BC_BAD_CAST_TO_ABSTRACT_COLLECTION")})).because("it's compiler generated code, but why?", new Ignore[]{In.languages(Language.KOTLIN).ignore("NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE")})).because("findbugs seems to be cleverer than kotlin compiler", new Ignore[]{In.languages(Language.KOTLIN).ignore("RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE")})).because("inline methods seem to cause this", new Ignore[]{In.languages(Language.KOTLIN).ignore("UPM_UNCALLED_PRIVATE_METHOD")});
    }

    public static PmdRuleset[] defaultPmdRulesets() {
        return new PmdRuleset[]{PmdRulesets.basic(), PmdRulesets.braces(), PmdRulesets.comments().maxLines(35).maxLineLen(120).requirement(PmdRulesets.Comments.Requirement.Ignored), PmdRulesets.codesize().excessiveMethodLength(40).tooManyMethods(30), PmdRulesets.design(), PmdRulesets.empty().allowCommentedEmptyCatch(true), PmdRulesets.exceptions(), PmdRulesets.imports(), PmdRulesets.junit(), PmdRulesets.naming().variableLen(1, 25).methodLen(2), PmdRulesets.optimizations(), PmdRulesets.strings(), PmdRulesets.sunSecure(), PmdRulesets.typeResolution(), PmdRulesets.unnecessary(), PmdRulesets.unused()};
    }

    public static CollectorTemplate<Ignore> minimalCheckstyleIgnore() {
        return (CollectorTemplate)CollectorTemplate.of(Ignore.class).because("I don't agree", new Ignore[]{In.everywhere().ignore("import.avoidStar", "custom.import.order.nonGroup.expected", "custom.import.order.lex", "javadoc.packageInfo", "javadoc.missing", "multiple.variable.declarations.comma", "final.parameter", "design.forExtension", "hidden.field", "inline.conditional.avoid", "magic.number")});
    }

    public static StyleChecks.Google adjustedGoogleStyleChecks() {
        return StyleChecks.google().maxLineLen(120).indentBasic(4).indentCase(4).paramName(VARIABLE_PATTERN).catchParamName(VARIABLE_PATTERN).localVarName(VARIABLE_PATTERN).memberName(VARIABLE_PATTERN).methodName(VARIABLE_PATTERN).emptyLineSeparatorTokens(30, 14, 15, 154, 12, 11, 9, 8, 10);
    }

    public static StyleChecks.Sun adjustedSunStyleChecks() {
        return StyleChecks.sun().maxLineLen(120).allowDefaultAccessMembers(true);
    }
}

