/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.jacoco;

import guru.nidi.codeassert.config.ActionResult;
import guru.nidi.codeassert.config.BaseCollector;
import guru.nidi.codeassert.config.CollectorConfig;
import guru.nidi.codeassert.config.Minima;
import guru.nidi.codeassert.config.UsageCounter;
import guru.nidi.codeassert.config.ValuedLocation;
import guru.nidi.codeassert.jacoco.CoverageType;
import guru.nidi.codeassert.util.ListUtils;
import java.util.List;

public class CoverageCollector
extends BaseCollector<ValuedLocation, Minima, CoverageCollector> {
    final CoverageType[] types;

    public CoverageCollector(CoverageType ... types) {
        this.types = types;
    }

    @Override
    public CoverageCollector config(final CollectorConfig<Minima> ... configs) {
        for (CollectorConfig<Minima> config : configs) {
            for (Minima minima : config.actions) {
                if (minima.getValueCount() <= this.types.length) continue;
                throw new IllegalArgumentException("Given " + minima.getValueCount() + " values, but expected only " + this.types.length);
            }
        }
        return new CoverageCollector(this.types){

            @Override
            public ActionResult accept(ValuedLocation issue) {
                return this.accept(issue, CoverageCollector.this, configs);
            }

            @Override
            public List<Minima> unused(UsageCounter counter) {
                return this.unused(counter, CoverageCollector.this, configs);
            }

            @Override
            public String toString() {
                return CoverageCollector.this.toString() + "\n" + ListUtils.join("\n", configs);
            }
        };
    }

    @Override
    public ActionResult accept(ValuedLocation issue) {
        return ActionResult.reject(null, 1);
    }

    @Override
    protected ActionResult doAccept(ValuedLocation issue, Minima action) {
        return action.accept(issue);
    }

    @Override
    public List<Minima> unused(UsageCounter counter) {
        return this.unusedNullAction(counter, true);
    }

    public String toString() {
        return "CoverageCollector";
    }
}

