/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.MethodAnnotation;
import guru.nidi.codeassert.config.ActionResult;
import guru.nidi.codeassert.config.BaseCollector;
import guru.nidi.codeassert.config.CollectorConfig;
import guru.nidi.codeassert.config.Ignore;
import guru.nidi.codeassert.config.Language;
import guru.nidi.codeassert.config.NamedLocation;
import guru.nidi.codeassert.config.UsageCounter;
import guru.nidi.codeassert.util.ListUtils;
import java.util.List;

public class BugCollector
extends BaseCollector<BugInstance, Ignore, BugCollector> {
    private final Integer maxRank;
    private final Integer minPriority;

    public BugCollector() {
        this(null, null);
    }

    private BugCollector(Integer maxRank, Integer minPriority) {
        this.maxRank = maxRank;
        this.minPriority = minPriority;
    }

    public BugCollector maxRank(int maxRank) {
        return new BugCollector(maxRank, this.minPriority);
    }

    public BugCollector minPriority(int minPriority) {
        return new BugCollector(this.maxRank, minPriority);
    }

    @Override
    public BugCollector config(final CollectorConfig<Ignore> ... configs) {
        return new BugCollector(this.maxRank, this.minPriority){

            @Override
            public ActionResult accept(BugInstance issue) {
                return this.accept(issue, BugCollector.this, configs);
            }

            @Override
            public List<Ignore> unused(UsageCounter counter) {
                return this.unused(counter, BugCollector.this, configs);
            }

            @Override
            public String toString() {
                return BugCollector.this.toString() + "\n" + ListUtils.join("\n", configs);
            }
        };
    }

    @Override
    public ActionResult accept(BugInstance issue) {
        return new ActionResult(!(this.maxRank != null && issue.getBugRank() > this.maxRank || this.minPriority != null && issue.getPriority() > this.minPriority), null, 1);
    }

    @Override
    protected ActionResult doAccept(BugInstance issue, Ignore action) {
        MethodAnnotation method = issue.getPrimaryMethod();
        String className = issue.getPrimaryClass().getClassName();
        String methodName = method == null ? null : method.getMethodName();
        Language language = Language.byFilename(issue.getPrimaryClass().getSourceFileName());
        return action.accept(new NamedLocation(issue.getType(), language, className, methodName, true));
    }

    @Override
    public List<Ignore> unused(UsageCounter counter) {
        return this.unusedNullAction(counter, this.maxRank != null || this.minPriority != null);
    }

    public String toString() {
        return (this.maxRank == null ? "" : "Rank <= " + this.maxRank + " ") + (this.minPriority == null ? "" : "Priority >= " + this.minPriority + " ");
    }
}

