/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.dependency;

import guru.nidi.codeassert.dependency.CodeElement;
import guru.nidi.codeassert.dependency.Dependencies;
import guru.nidi.codeassert.dependency.DependencyRule;
import guru.nidi.codeassert.dependency.DependencyRuler;
import guru.nidi.codeassert.dependency.RuleAccessor;
import guru.nidi.codeassert.dependency.Tarjan;
import guru.nidi.codeassert.model.Scope;
import guru.nidi.codeassert.model.UsingElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DependencyRules {
    private static final Logger LOG = LoggerFactory.getLogger(DependencyRules.class);
    private static final Pattern ANONYMOUS_CLASS = Pattern.compile(".*?\\$\\d+");
    private static final ThreadLocal<DependencyRules> CURRENT = new ThreadLocal();
    private final List<DependencyRule> rules;
    private final boolean allowAll;
    private final boolean allowIntraPackageCycles;
    final boolean allowIntraPackageDeps;

    private DependencyRules(List<DependencyRule> rules, boolean allowAll, boolean allowIntraPackageCycles, boolean allowIntraPackageDeps) {
        this.rules = rules;
        this.allowAll = allowAll;
        this.allowIntraPackageCycles = allowIntraPackageCycles;
        this.allowIntraPackageDeps = allowIntraPackageDeps;
    }

    public static DependencyRules allowAll() {
        return new DependencyRules(new ArrayList<DependencyRule>(), true, true, true);
    }

    public static DependencyRules denyAll() {
        return new DependencyRules(new ArrayList<DependencyRule>(), false, false, false);
    }

    public DependencyRules allowIntraPackageCycles(boolean allowIntraPackageCycles) {
        return new DependencyRules(this.rules, this.allowAll, allowIntraPackageCycles, this.allowIntraPackageDeps);
    }

    public DependencyRules allowIntraPackageDependencies(boolean allowIntraPackageDeps) {
        return new DependencyRules(this.rules, this.allowAll, this.allowIntraPackageCycles, allowIntraPackageDeps);
    }

    public DependencyRule addRule(String pack) {
        return this.addRule(this.rule(pack));
    }

    public DependencyRule addRule(DependencyRule pack) {
        this.rules.add(pack);
        return pack;
    }

    public DependencyRule addExternal(String pack) {
        DependencyRule rule = this.rule(pack).optional();
        rule.mayBeUsedBy(this.rule("*"));
        return this.addRule(rule);
    }

    public DependencyRules withRules(String basePackage, DependencyRuler ruler) {
        return this.doWithRules(this.addPackages(basePackage, ruler.getClass()), false, ruler);
    }

    public DependencyRules withAbsoluteRules(DependencyRuler ... rulers) {
        return this.doWithRules(false, false, rulers);
    }

    public DependencyRules withRelativeRules(DependencyRuler ... rulers) {
        return this.doWithRules(true, false, rulers);
    }

    public DependencyRules withExternals(DependencyRuler ... rulers) {
        return this.doWithRules(false, true, rulers);
    }

    public DependencyRules withExternals(String ... externals) {
        for (String external : externals) {
            this.addExternal(external);
        }
        return this;
    }

    private DependencyRules doWithRules(boolean withRulerName, boolean external, DependencyRuler ... rulers) {
        for (DependencyRuler ruler : rulers) {
            this.doWithRules(this.addPackages("", withRulerName ? ruler.getClass() : null), external, ruler);
        }
        return this;
    }

    private DependencyRules doWithRules(String basePackage, boolean external, DependencyRuler ruler) {
        CURRENT.set(this);
        try {
            List<DependencyRule> ruleFields = this.initFields(basePackage, ruler);
            if (basePackage.length() > 0) {
                ruler.base = this.rule(this.addPackages(basePackage, ""));
            }
            ruler.unnamed = this.rule("<Unnamed Package>");
            ruler.all = this.rule(this.addPackages(basePackage, "*"));
            ruler.defineRules();
            this.postProcessFields(ruleFields, external);
            DependencyRules dependencyRules = this;
            return dependencyRules;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access field", e);
        }
        finally {
            CURRENT.remove();
        }
    }

    static DependencyRule addRuleToCurrent(DependencyRule rule) {
        DependencyRules rules = CURRENT.get();
        if (rules != null) {
            rules.addRule(rule);
        }
        return rule;
    }

    private List<DependencyRule> initFields(String basePackage, DependencyRuler ruler) throws IllegalAccessException {
        ArrayList<DependencyRule> ruleFields = new ArrayList<DependencyRule>();
        for (Field f : ruler.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            if (f.getType() == CodeElement.class) {
                ruleFields.add(this.initField(basePackage, ruler, f));
            }
            if (f.getType() != DependencyRule.class) continue;
            ruleFields.add(this.addRule(this.initField(basePackage, ruler, f)));
        }
        return ruleFields;
    }

    private DependencyRule initField(String basePackage, DependencyRuler ruler, Field f) throws IllegalAccessException {
        CodeElement value = (CodeElement)f.get(ruler);
        if (value instanceof DependencyRule && !"*".equals(value.pattern.getPattern())) {
            return (DependencyRule)value;
        }
        String name = f.getName();
        this.deprecationWarnings(name);
        String pack = this.addPackages(basePackage, "$self".equals(name) ? "" : DependencyRules.camelCaseToDotCase(name));
        DependencyRule rule = this.rule(pack);
        f.set(ruler, rule);
        return rule;
    }

    private void deprecationWarnings(String name) {
        if ("$self".equals(name)) {
            LOG.warn("'DependencyRule $self': $self is deprecated. Use base() instead.");
        }
        if ("_".equals(name)) {
            LOG.warn("'DependencyRule _': _ is deprecated. Use all() instead.");
        }
    }

    private void postProcessFields(List<DependencyRule> ruleFields, boolean external) {
        if (external) {
            for (DependencyRule rule : ruleFields) {
                if (!rule.isEmpty()) continue;
                rule.mayBeUsedBy(this.rule("*"));
            }
        }
    }

    private String addPackages(String base, Class<?> clazz) {
        if (clazz == null) {
            return this.addPackages(base, "");
        }
        if (this.isAnonymous(clazz)) {
            return this.addPackages(base.length() > 0 ? base : clazz.getPackage().getName(), "");
        }
        return this.addPackages(base, DependencyRules.camelCaseToDotCase(this.reallySimpleName(clazz)));
    }

    private String addPackages(String p1, String p2) {
        return p1.length() > 0 && !p1.endsWith(".") && p2.length() > 0 ? p1 + "." + p2 : p1 + p2;
    }

    private boolean isAnonymous(Class<?> clazz) {
        return clazz.isAnonymousClass() || ANONYMOUS_CLASS.matcher(clazz.getSimpleName()).matches();
    }

    private String reallySimpleName(Class<?> clazz) {
        String simple = clazz.getSimpleName();
        String prefix = clazz.getEnclosingMethod() == null ? "" : clazz.getEnclosingMethod().getName() + "$";
        return simple.startsWith(prefix) ? simple.substring(prefix.length()) : simple;
    }

    private static String camelCaseToDotCase(String s) {
        StringBuilder res = new StringBuilder();
        boolean dollarMode = s.contains("$");
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_' && i == s.length() - 1) {
                res.append(res.length() == 0 || res.charAt(res.length() - 1) == '.' ? "*" : ".*");
                continue;
            }
            res.append(DependencyRules.processChar(dollarMode, i == 0, c));
        }
        return res.toString();
    }

    public DependencyRule rule(String pattern) {
        return new DependencyRule(pattern, this.allowAll);
    }

    private static String processChar(boolean dollarMode, boolean firstChar, char c) {
        if (dollarMode) {
            if (c == '$' && !firstChar) {
                return ".";
            }
            return Character.toString(c);
        }
        if (Character.isUpperCase(c)) {
            return (firstChar ? "" : ".") + Character.toLowerCase(c);
        }
        return Character.toString(c);
    }

    public <T extends UsingElement<T>> Dependencies analyzeRules(Scope<T> scope) {
        Dependencies result = new Dependencies();
        for (DependencyRule rule : this.rules) {
            result.merge(rule.analyzer(scope, this).analyze());
        }
        for (UsingElement elem : scope) {
            if (elem.matchesAny(this.rules)) continue;
            result.undefined.add(elem.getName());
        }
        result.normalize();
        result.cycles.addAll(new Tarjan<T>().analyzeCycles(scope, this.allowIntraPackageCycles));
        return result;
    }

    <T extends UsingElement<T>> int mostSpecificUsageMatch(T from, T to, RuleAccessor accessor) {
        int s = 0;
        for (DependencyRule rule : this.rules) {
            if (!rule.matches(to)) continue;
            s = Math.max(s, from.mostSpecificMatch(accessor.access(rule)));
        }
        return s;
    }
}

