/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.dependency;

import guru.nidi.codeassert.dependency.Dependencies;
import guru.nidi.codeassert.dependency.DependencyResult;
import guru.nidi.codeassert.dependency.MatcherUtils;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class DependencyResultMatcher
extends TypeSafeMatcher<DependencyResult> {
    private static final String SIMPLE_FORMAT = "%-12s %-45s %s%n";
    private static final String ARROW_FORMAT = "%-12s %-45s %s%n";
    private final boolean nonExisting;
    private final boolean undefined;

    public DependencyResultMatcher(boolean nonExisting, boolean undefined) {
        this.nonExisting = nonExisting;
        this.undefined = undefined;
    }

    protected boolean matchesSafely(DependencyResult item) {
        Dependencies dependencies = (Dependencies)item.findings();
        return !(!dependencies.getMissing().isEmpty() || !dependencies.getDenied().isEmpty() || !dependencies.getNotExisting().isEmpty() && this.nonExisting || !dependencies.getUndefined().isEmpty() && this.undefined);
    }

    public void describeTo(Description description) {
        description.appendText("Comply with rules");
    }

    protected void describeMismatchSafely(DependencyResult item, Description description) {
        Dependencies dependencies = (Dependencies)item.findings();
        description.appendText("\n");
        this.describeNotExisting(dependencies, description);
        this.describeUndefined(dependencies, description);
        this.describeMissing(dependencies, description);
        this.describeForbidden(dependencies, description);
    }

    private void describeForbidden(Dependencies result, Description description) {
        for (String elem : MatcherUtils.sorted(result.getDenied().getElements())) {
            description.appendText(String.format("%-12s %-45s %s%n", "DENIED", elem + " ->", "This dependency is forbidden."));
            description.appendText(MatcherUtils.deps("  ", result.getDenied().getDependencies(elem)));
        }
    }

    private void describeMissing(Dependencies result, Description description) {
        for (String elem : MatcherUtils.sorted(result.getMissing().getElements())) {
            description.appendText(String.format("%-12s %-45s %s%n", "MISSING", elem + " ->", "This dependency is missing."));
            for (String dep : MatcherUtils.sorted(result.getMissing().getDependencies(elem).keySet())) {
                description.appendText("  " + dep + "\n");
            }
        }
    }

    private void describeUndefined(Dependencies result, Description description) {
        if (this.undefined) {
            for (String elem : MatcherUtils.sorted(result.getUndefined())) {
                description.appendText(String.format("%-12s %-45s %s%n", "UNDEFINED", elem, "There is no rule given for this element."));
            }
        }
    }

    private void describeNotExisting(Dependencies result, Description description) {
        if (this.nonExisting) {
            for (String elem : MatcherUtils.sortedPatterns(result.getNotExisting())) {
                description.appendText(String.format("%-12s %-45s %s%n", "NOT_EXISTING", elem, "There is a rule for this element, but it has not been found in the code."));
            }
        }
    }
}

