/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.dependency;

import guru.nidi.codeassert.model.UsingElement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

class DependencyMap {
    private final Map<String, Map<String, Info>> map = new LinkedHashMap<String, Map<String, Info>>();

    DependencyMap() {
    }

    public <T> void with(int specificity, UsingElement<T> from, UsingElement<T> to) {
        this.with(specificity, from.getName(), from.usedVia(to), to.getName());
    }

    DependencyMap with(int specificity, String from, Collection<String> vias, String to) {
        Map deps = this.map.computeIfAbsent(from, k -> new HashMap());
        Info info = (Info)deps.get(to);
        if (info == null) {
            deps.put(to, new Info(vias, specificity));
        } else {
            info.getVias().addAll(vias);
        }
        return this;
    }

    DependencyMap with(String from, DependencyMap other) {
        Map<String, Info> infos = other.getDependencies(from);
        for (Map.Entry<String, Info> entry : infos.entrySet()) {
            Info info = entry.getValue();
            this.with(info.getSpecificity(), from, info.getVias(), entry.getKey());
        }
        return this;
    }

    public DependencyMap without(int specificity, String from, String to) {
        Info info;
        Map<String, Info> deps = this.map.get(from);
        if (deps != null && (info = deps.get(to)) != null && specificity > info.specificity) {
            deps.remove(to);
            if (deps.isEmpty()) {
                this.map.remove(from);
            }
        }
        return this;
    }

    public DependencyMap without(DependencyMap other) {
        for (Map.Entry<String, Map<String, Info>> entry : other.map.entrySet()) {
            for (Map.Entry<String, Info> to : entry.getValue().entrySet()) {
                this.without(to.getValue().specificity, entry.getKey(), to.getKey());
            }
        }
        return this;
    }

    public void merge(DependencyMap deps) {
        for (Map.Entry<String, Map<String, Info>> entry : deps.map.entrySet()) {
            Map<String, Info> ds = this.map.get(entry.getKey());
            if (ds == null) {
                this.map.put(entry.getKey(), entry.getValue());
                continue;
            }
            ds.putAll(entry.getValue());
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clear() {
        this.map.clear();
    }

    public Set<String> getElements() {
        return this.map.keySet();
    }

    public Map<String, Info> getDependencies(String name) {
        return this.map.get(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyMap that = (DependencyMap)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public static class Info {
        private final Set<String> vias;
        private final int specificity;

        Info(Collection<String> vias, int specificity) {
            this.vias = new HashSet<String>(vias);
            this.specificity = specificity;
        }

        public Set<String> getVias() {
            return this.vias;
        }

        public int getSpecificity() {
            return this.specificity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Info info = (Info)o;
            return this.vias.equals(info.vias);
        }

        public int hashCode() {
            return this.vias.hashCode();
        }

        public String toString() {
            return this.vias.toString();
        }
    }
}

