/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.codeassert.dependency;

import guru.nidi.codeassert.dependency.Dependencies;
import guru.nidi.codeassert.dependency.DependencyMap;
import guru.nidi.codeassert.dependency.DependencyResult;
import guru.nidi.codeassert.dependency.MatcherUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class DependencyCycleMatcher
extends TypeSafeMatcher<DependencyResult> {
    private static final Comparator<DependencyMap> DEP_MAP_COMPARATOR = new DependencyMapComparator();

    protected boolean matchesSafely(DependencyResult item) {
        return ((Dependencies)item.findings()).getCycles().isEmpty();
    }

    public void describeTo(Description description) {
        description.appendText("Does not have cycles");
    }

    protected void describeMismatchSafely(DependencyResult item, Description description) {
        description.appendText("\n");
        Set<DependencyMap> result = ((Dependencies)item.findings()).getCycles();
        for (DependencyMap cycle : DependencyCycleMatcher.sortedDepMaps(result)) {
            description.appendText(String.format("%-12s %s%n", "CYCLE", "This group of elements has mutual dependencies:"));
            for (String elem : MatcherUtils.sorted(cycle.getElements())) {
                description.appendText("  " + elem + " ->\n");
                description.appendText(MatcherUtils.deps("    ", cycle.getDependencies(elem)));
            }
        }
    }

    private static List<DependencyMap> sortedDepMaps(Collection<DependencyMap> maps) {
        ArrayList<DependencyMap> sorted = new ArrayList<DependencyMap>(maps);
        sorted.sort(DEP_MAP_COMPARATOR);
        return sorted;
    }

    private static class DependencyMapComparator
    implements Comparator<DependencyMap> {
        private DependencyMapComparator() {
        }

        @Override
        public int compare(DependencyMap d1, DependencyMap d2) {
            Iterator<String> i1 = MatcherUtils.sorted(d1.getElements()).iterator();
            Iterator<String> i2 = MatcherUtils.sorted(d2.getElements()).iterator();
            while (i1.hasNext() && i2.hasNext()) {
                String s2;
                String s1 = i1.next();
                int c = s1.compareTo(s2 = i2.next());
                if (c == 0) continue;
                return c;
            }
            if (i1.hasNext()) {
                return 1;
            }
            if (i2.hasNext()) {
                return -1;
            }
            return 0;
        }
    }
}

